/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.jobmanagement.composite.ScheduleListComposite;

/**
 * ジョブ履歴テーブルのSelectionChangedListenerクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleSelectionChangedListener implements
        ISelectionChangedListener {
    protected ScheduleListComposite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite
     * @since 1.0.0
     */
    public ScheduleSelectionChangedListener(ScheduleListComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        ArrayList info = null;

        //選択行を取得
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            info = (ArrayList) ((StructuredSelection) event.getSelection())
                    .getFirstElement();
        }

        m_composite.setSelectItem(info);
    }
}

