/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.view.ForwardFileView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;

/**
 * ジョブ詳細テーブルのSelectionChangedListenerクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobDetailSelectionChangedListener implements
        ISelectionChangedListener {
    protected DetailComposite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite
     * @since 1.0.0
     */
    public JobDetailSelectionChangedListener(DetailComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        String sessionId = null;
        String jobId = null;

        //ジョブIDを取得
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            CommonTableTreeItem item = (CommonTableTreeItem) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            ArrayList info = item.getData();
            jobId = (String) info.get(JobDetailTableDefine.JOB_ID);

            //ジョブIDを設定
            m_composite.setJobId(jobId);
        }

        //セッションIDを設定
        sessionId = m_composite.getSessionId();

        //アクティブページを手に入れる
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();

        //ビューを更新する
        IViewPart viewPart = page.findView(JobNodeDetailView.ID);
        if (viewPart != null) {
            JobNodeDetailView view = (JobNodeDetailView) viewPart
                    .getAdapter(JobNodeDetailView.class);
            view.update(sessionId, jobId);
        }
        
        //ビューを更新する
        viewPart = page.findView(ForwardFileView.ID);
        if (viewPart != null) {
        	ForwardFileView view = (ForwardFileView) viewPart
                    .getAdapter(ForwardFileView.class);
            view.update(sessionId, jobId);
        }
    }
}

