/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.view.JobDetailView;

/**
 * ジョブ履歴テーブルのSelectionChangedListenerクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistorySelectionChangedListener implements
        ISelectionChangedListener {
    protected HistoryComposite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite
     * @since 1.0.0
     */
    public HistorySelectionChangedListener(HistoryComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        String sessionId = null;
        String jobId = null;

        //セッションIDを取得
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            sessionId = (String) info.get(HistoryTableDefine.SESSION_ID);
            jobId = (String) info.get(HistoryTableDefine.JOB_ID);
            //セッションIDを設定
            m_composite.setSessionId(sessionId);
            //ジョブIDを設定
            m_composite.setJobId(jobId);
        }

        //アクティブページを手に入れる
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        //ビューを更新する
        IViewPart viewPart = page.findView(JobDetailView.ID);
        if (viewPart != null) {
            JobDetailView view = (JobDetailView) viewPart
                    .getAdapter(JobDetailView.class);
            view.update(sessionId);
        }
    }
}

