/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetWaitRuleTableDefine;
import com.clustercontrol.jobmanagement.bean.ConditionTypeConstant;
import com.clustercontrol.jobmanagement.bean.JobObjectInfo;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.jobmanagement.bean.WaitRuleTableDefine;
import com.clustercontrol.jobmanagement.composite.action.WaitRuleSelectionChangedListener;
import com.clustercontrol.jobmanagement.dialog.WaitRuleDialog;
import com.clustercontrol.util.Messages;

/**
 * 待ち条件コンポジットクラス
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class WaitRuleComposite extends Composite {
	protected CommonTableViewer m_viewer = null;
	
	protected Button m_andCondition = null;
	protected Button m_orCondition = null;
	
	protected Button m_endCondition = null;
	protected Group m_endConditionGroup = null;
	protected Text m_endValue = null;
	
	protected Button m_createCondition = null;
	protected Button m_modifyCondition = null;
	protected Button m_deleteCondition = null;
	
	protected JobWaitRuleInfo m_waitRule = null;
	
	protected Shell m_shell = null;
	
	protected ArrayList m_selectItem = null;
	
	protected String m_parentJobId = null;
	
	protected String m_jobId = null;
	
	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 * @param style
	 * @since 1.0.0
	 */
	public WaitRuleComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
		m_shell = this.getShell();
	}
	
	/**
	 * 初期化処理
	 * 
	 * @since 1.0.0
	 */
	private void initialize() {
		RowLayout layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.spacing = 1;
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.fill = true;
		this.setLayout(layout);
		
		Composite composite = null;
		RowLayout rowLayout = null;
		
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);
		
		Label tableTitle = new Label(composite, SWT.NONE);
		tableTitle.setText(Messages.getString("object.list"));
		
		Table table = new Table(composite, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setLayoutData(new RowData(430, 80));
		
		composite = new Composite(composite, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 5;
		composite.setLayout(rowLayout);
		
		//判定対象の追加
		Label dummy1 = new Label(composite, SWT.NONE);
		dummy1.setLayoutData(new RowData(190, SizeConstant.SIZE_LABEL_HEIGHT));
		m_createCondition = new Button(composite, SWT.NONE);
		m_createCondition.setText(Messages.getString("add"));
		m_createCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_createCondition.addSelectionListener(new SelectionAdapter() {
			@SuppressWarnings("unchecked")
			public void widgetSelected(SelectionEvent e) {
				WaitRuleDialog dialog = new WaitRuleDialog(m_shell,
						m_parentJobId, m_jobId);
				if (dialog.open() == IDialogConstants.OK_ID) {
					ArrayList info = dialog.getInputData();
					ArrayList list = (ArrayList) m_viewer.getInput();
					if (list == null) {
						list = new ArrayList();
					}
					list.add(info);
					m_viewer.setInput(list);
				}
			}
		});
		
		//判定対象の変更
		m_modifyCondition = new Button(composite, SWT.NONE);
		m_modifyCondition.setText(Messages.getString("modify"));
		m_modifyCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_modifyCondition.addSelectionListener(new SelectionAdapter() {
			@SuppressWarnings("unchecked")
			public void widgetSelected(SelectionEvent e) {
				WaitRuleDialog dialog = new WaitRuleDialog(m_shell,
						m_parentJobId, m_jobId);
				if (m_selectItem instanceof ArrayList) {
					dialog.setInputData((ArrayList) m_selectItem);
					if (dialog.open() == IDialogConstants.OK_ID) {
						ArrayList info = dialog.getInputData();
						ArrayList list = (ArrayList) m_viewer.getInput();
						list.remove(m_selectItem);
						list.add(info);
						m_selectItem = null;
						m_viewer.setInput(list);
					}
				} else {
					
				}
			}
		});
		
		//判定対象の削除
		m_deleteCondition = new Button(composite, SWT.NONE);
		m_deleteCondition.setText(Messages.getString("delete"));
		m_deleteCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_deleteCondition.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				if (m_selectItem instanceof ArrayList) {
					ArrayList list = (ArrayList) m_viewer.getInput();
					list.remove(m_selectItem);
					m_selectItem = null;
					m_viewer.setInput(list);
				} else {
					
				}
			}
		});
		
		//判定対象の条件関係
		Group group = new Group(this, SWT.NONE);
		group.setText(Messages.getString("condition.between.objects"));
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		group.setLayout(rowLayout);
		
		composite = new Composite(group, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		m_andCondition = new Button(composite, SWT.RADIO);
		m_andCondition.setText(Messages.getString("and"));
		m_andCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_orCondition = new Button(composite, SWT.RADIO);
		m_orCondition.setText(Messages.getString("or"));
		m_orCondition.setLayoutData(new RowData(100,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);
		
		//条件を満たさないときに終了
		Label dummy2 = new Label(composite, SWT.NONE);
		dummy2.setLayoutData(new RowData(190, SizeConstant.SIZE_LABEL_HEIGHT));
		m_endCondition = new Button(composite, SWT.CHECK);
		m_endCondition
		.setText(Messages.getString("end.if.condition.unmatched"));
		m_endCondition.setLayoutData(new RowData(220,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_endCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_endConditionGroup.setEnabled(true);
					m_endValue.setEnabled(true);
				} else {
					m_endConditionGroup.setEnabled(false);
					m_endValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		m_endConditionGroup = new Group(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		m_endConditionGroup.setLayout(rowLayout);
		
		composite = new Composite(m_endConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		Label endValueTitle = new Label(composite, SWT.LEFT);
		endValueTitle.setText(Messages.getString("end.value") + " : ");
		endValueTitle.setLayoutData(new RowData(80,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_endValue = new Text(composite, SWT.BORDER);
		m_endValue
		.setLayoutData(new RowData(100, SizeConstant.SIZE_TEXT_HEIGHT));
		m_endValue.addVerifyListener(new NumberVerifyListener());
		
		m_viewer = new CommonTableViewer(table);
		m_viewer.createTableColumn(GetWaitRuleTableDefine.get(),
				WaitRuleTableDefine.SORT_COLUMN_INDEX,
				WaitRuleTableDefine.SORT_ORDER);
		m_viewer
		.addSelectionChangedListener(new WaitRuleSelectionChangedListener(
				this));
	}
	
	/**
	 * 待ち条件情報反映
	 *  
	 */
	@SuppressWarnings("unchecked")
	public void reflectWaitRuleInfo() {
		if (m_waitRule instanceof JobWaitRuleInfo) {
			//判定対象と開始条件値設定
			ArrayList list = m_waitRule.getObject();
			if(list != null){
				ArrayList tableData = new ArrayList();
				for (int i = 0; i < list.size(); i++) {
					JobObjectInfo info = (JobObjectInfo) list.get(i);
					ArrayList tableLineData = new ArrayList();
					tableLineData.add(new Integer(info.getType()));
					if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_STAUS) {
						tableLineData.add(info.getJobId());
						tableLineData.add(EndStatusConstant.typeToString(info.getValue()));
					}
					else if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
						tableLineData.add(info.getJobId());
						tableLineData.add(new Integer(info.getValue()));
					}
					else {
						tableLineData.add("");
						tableLineData.add(info.getTime());
					}
					tableData.add(tableLineData);
				}
				m_viewer.setInput(tableData);
			}
			
			//条件関係設定
			if (m_waitRule.getCondition() == ConditionTypeConstant.TYPE_AND) {
				m_andCondition.setSelection(true);
			} else {
				m_orCondition.setSelection(true);
			}
			
			//開始条件を満たさないとき終了 設定
			m_endCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule
					.getEndCondition()));
			
			//終了値
			m_endValue.setText(String.valueOf(m_waitRule.getEndValue()));
		} else {
			m_andCondition.setSelection(true);
			m_endCondition.setSelection(false);
			m_endValue.setText(String
					.valueOf(EndStatusConstant.INITIAL_VALUE_NORMAL));
		}
		
		//開始条件を満たさないとき終了
		if (m_endCondition.getSelection()) {
			m_endConditionGroup.setEnabled(true);
			m_endValue.setEnabled(true);
		} else {
			m_endConditionGroup.setEnabled(false);
			m_endValue.setEnabled(false);
		}
	}
	
	/**
	 * 待ち条件情報設定
	 * 
	 * @param m_waitRule
	 */
	public void setWaitRuleInfo(JobWaitRuleInfo start) {
		m_waitRule = start;
	}
	
	/**
	 * 待ち条件情報取得
	 * 
	 * @return
	 */
	public JobWaitRuleInfo getWaitRuleInfo() {
		return m_waitRule;
	}
	
	/**
	 * 待ち条件情報作成
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult createWaitRuleInfo() {
		ValidateResult result = null;
		
		//実行内容情報クラスのインスタンスを作成・取得
		if (m_waitRule == null)
			m_waitRule = new JobWaitRuleInfo();
		
		//判定対象と開始条件値取得
		ArrayList list = new ArrayList();
		ArrayList tableData = (ArrayList) m_viewer.getInput();
		HashMap map = new HashMap();
		if (tableData instanceof ArrayList) {
			for (int i = 0; i < tableData.size(); i++) {
				ArrayList tableLineData = (ArrayList) tableData.get(i);
				JobObjectInfo info = new JobObjectInfo();
				Integer type = (Integer) tableLineData
				.get(WaitRuleTableDefine.JUDGMENT_OBJECT);
				info.setType(type.intValue());
				if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_STAUS) {
					info.setJobId((String) tableLineData
							.get(WaitRuleTableDefine.JOB_ID));
					String value = (String) tableLineData
					.get(WaitRuleTableDefine.START_VALUE);
					info.setValue(EndStatusConstant.stringToType(value));
					
					//重複チェック
					Integer checkValue = (Integer) map.get(info.getJobId() + info.getType());
					if (checkValue == null
							|| checkValue.intValue() != info.getValue()) {
						list.add(info);
						map.put(info.getJobId() + info.getType(), new Integer(info.getValue()));
					}
				}
				else if (info.getType() == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
					info.setJobId((String) tableLineData
							.get(WaitRuleTableDefine.JOB_ID));
					Integer value = (Integer) tableLineData
					.get(WaitRuleTableDefine.START_VALUE);
					info.setValue(value.intValue());
					
					//重複チェック
					Integer checkValue = (Integer) map.get(info.getJobId() + info.getType());
					if (checkValue == null
							|| checkValue.intValue() != info.getValue()) {
						list.add(info);
						map.put(info.getJobId() + info.getType(), new Integer(info.getValue()));
					}
				}
				else {
					Date value = (Date) tableLineData
					.get(WaitRuleTableDefine.START_VALUE);
					info.setTime(value);
					
					//重複チェック
					if (map.get("TIME") == null) {
						list.add(info);
						map.put("TIME", "1");
					}
				}
			}
		}
		m_waitRule.setObject(list);
		
		//条件関係取得
		if (m_andCondition.getSelection()) {
			m_waitRule.setCondition(ConditionTypeConstant.TYPE_AND);
		} else {
			m_waitRule.setCondition(ConditionTypeConstant.TYPE_OR);
		}
		
		//開始条件を満たさないとき終了 設定
		m_waitRule.setEndCondition(YesNoConstant.booleanToType(m_endCondition
				.getSelection()));
		
		//終了値取得
		try {
			m_waitRule.setEndValue(Integer.parseInt(m_endValue.getText()));
		} catch (NumberFormatException e) {
			if (m_waitRule.getEndCondition() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.21"));
				return result;
			}
		}
		
		return null;
	}
	
	/**
	 * 選択アイテムを取得
	 * 
	 * @return
	 */
	public ArrayList getSelectItem() {
		return m_selectItem;
	}
	
	/**
	 * 選択アイテムを設定
	 * 
	 * @param selectItem
	 */
	public void setSelectItem(ArrayList selectItem) {
		m_selectItem = selectItem;
	}
	
	/**
	 * @return Returns the m_parentJobId.
	 */
	public String geParentJobId() {
		return m_parentJobId;
	}
	
	/**
	 * @param parentJobId
	 *            The m_parentJobId to set.
	 */
	public void setParentJobId(String parentJobId) {
		m_parentJobId = parentJobId;
	}
	
	/**
	 * @return Returns the m_jobId.
	 */
	public String geJobId() {
		return m_jobId;
	}
	
	/**
	 * @param jobId
	 *            The m_jobId to set.
	 */
	public void setJobId(String jobId) {
		m_jobId = jobId;
	}
}