/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetSchedule;
import com.clustercontrol.jobmanagement.action.GetScheduleTableDefine;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.clustercontrol.jobmanagement.composite.action.ScheduleSelectionChangedListener;

/**
 * スケジュール一覧コンポジット
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScheduleListComposite extends Composite {
    protected CommonTableViewer m_viewer = null;

    protected ArrayList m_selectItem = null;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public ScheduleListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 初期化処理
     * 
     * @since 1.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetScheduleTableDefine.get(),
                ScheduleTableDefine.SORT_COLUMN_INDEX,
                ScheduleTableDefine.SORT_ORDER);

        m_viewer
                .addSelectionChangedListener(new ScheduleSelectionChangedListener(
                        this));
    }

    /**
     * 更新処理
     * 
     * @since 1.0.0
     */
    public void update() {
        ArrayList scheduleInfo = getScheduleInfo();

        m_viewer.setInput(scheduleInfo);
    }

    /**
     * スケジュール情報取得
     * 
     * @return スケジュール情報
     * @since 1.0.0
     */
    private ArrayList getScheduleInfo() {
        ArrayList scheduleInfo = null;

        //スケジュール情報取得
        GetSchedule getSchedule = new GetSchedule();
        scheduleInfo = getSchedule.getSchedule();

        return scheduleInfo;
    }

    /**
     * このコンポジットが利用するテーブルビューアを返します。
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを返します。
     * 
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

    /**
     * @return Returns the selectItem.
     */
    public ArrayList getSelectItem() {
        return m_selectItem;
    }

    /**
     * @param shceduleId
     *            The selectItem to set.
     */
    public void setSelectItem(ArrayList selectItem) {
        this.m_selectItem = selectItem;
    }
}