/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;
import java.util.Date;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.jobmanagement.action.GetRunScheduleList;
import com.clustercontrol.jobmanagement.action.GetRunScheduleListTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.clustercontrol.jobmanagement.composite.action.RunScheduleSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;

/**
 * カレンダ一覧コンポジットクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleListComposite extends Composite {
    protected RunScheduleTableViewer m_viewer = null;
    
    protected Table m_table = null;
    protected Label m_labelCount = null;
    
    protected String m_scheduleId = null;
    protected Date m_base = null;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     * @since 2.0.0
     */
    public RunScheduleListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 初期化処理
     * 
     * @since 2.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        
		//カレンダ一覧テーブル作成
        m_table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
        m_table.setHeaderVisible(true);
        m_table.setLinesVisible(true);
        
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_table.setLayoutData(gridData);
        
        m_labelCount = new Label(this, SWT.RIGHT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_labelCount.setLayoutData(gridData);

        m_viewer = new RunScheduleTableViewer(m_table);
        m_viewer.createTableColumn(GetRunScheduleListTableDefine.get(),
        		RunScheduleListTableDefine.SORT_COLUMN_INDEX,
        		RunScheduleListTableDefine.SORT_ORDER);

        m_viewer.addSelectionChangedListener(new RunScheduleSelectionChangedListener(this));
    
        m_viewer.getTable().getVerticalBar().addSelectionListener(
        		new VerticalBarSelectionListener(this));
    }

    /**
     * 更新処理
     * 
     * @since 2.0.0
     */
    public void update() {
        ArrayList info = null;

        //予定一覧情報取得
        GetRunScheduleList getList = new GetRunScheduleList();
        info = getList.get();
        if (info == null) {
        	info = new ArrayList();
        }
        
        m_viewer.setInput(info);
        
        selectJob(info);

        Object[] args = { new Integer(info.size()) };
        m_labelCount.setText(Messages.getString("records", args));
    }
    
    /**
     * 選択処理
     * 
     * @param info
     */
    public void selectJob(ArrayList info) {
        if (m_scheduleId != null && m_scheduleId.length() > 0) {
            int index = -1;
            for (int i = 0; i < info.size(); i++) {
                ArrayList line = (ArrayList) info.get(i);
                String scheduleId = (String) line
                        .get(RunScheduleListTableDefine.SCHE_ID);
                if (m_scheduleId.compareTo(scheduleId) == 0) {
                    index = i;
                    break;
                }
            }
            if (index == -1) {
            	m_scheduleId = null;
            } else {
                m_viewer.setSelection(
                		new StructuredSelection(info.get(index)), true);
            }
        }
    }

    /**
     * このコンポジットが利用するテーブルビューアを返します。
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを返します。
     * 
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }
    
	/**
	 * @return
	 */
	public String getScheduleId() {
		return m_scheduleId;
	}
	
	/**
	 * @param scheduleId
	 */
	public void setScheduleId(String scheduleId) {
		m_scheduleId = scheduleId;
	}
}