/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.JobImageConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;

/**
 * ジョブツリーLabelProviderクラス
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
class JobTreeLabelProvider extends LabelProvider {

	
    public String getText(Object element) {
        JobInfo info = ((JobTreeItem) element).getData();

        int type = info.getType();
        if (type == JobConstant.TYPE_COMPOSITE) {
            return info.getName();
        } else {
            return info.getName() + " (" + info.getId() + ")";
        }
    }

    public Image getImage(Object element) {
        int type = ((JobTreeItem) element).getData().getType();
        
        return JobImageConstant.typeToImage(type);
    }
}