/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetForwardFile;
import com.clustercontrol.jobmanagement.action.GetForwardFileTableDefine;
import com.clustercontrol.jobmanagement.bean.ForwardFileTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ファイル転送コンポジット
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ForwardFileComposite extends Composite {
    protected CommonTableViewer m_viewer = null;

    protected String m_sessionId = null;

    protected String m_jobId = null;

    protected Label m_idLabel = null;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @param style
     */
    public ForwardFileComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 初期化処理
     * 
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        //セッションID・ジョブIDラベル作成
        m_idLabel = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        m_idLabel.setLayoutData(gridData);

        //ファイル転送テーブル作成
        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetForwardFileTableDefine.get(),
        		ForwardFileTableDefine.SORT_COLUMN_INDEX,
        		ForwardFileTableDefine.SORT_ORDER);
    }

    /**
     * 更新処理
     * 
     * @param sessionId
     * @param jobId
     */
    public void update(String sessionId, String jobId) {
        ArrayList list = null;

        //ファイル転送情報取得
        GetForwardFile getForwardFile = new GetForwardFile();
        if (sessionId != null && jobId != null) {
            list = getForwardFile.get(sessionId, jobId);
        } else {
            list = new ArrayList();
        }

        m_viewer.setInput(list);

        m_sessionId = sessionId;
        m_jobId = jobId;

        //セッションID・ジョブIDを表示
        if (m_sessionId != null && m_jobId != null) {
            m_idLabel.setText(Messages.getString("session.id") + " : "
                    + m_sessionId + ",   " + Messages.getString("job.id")
                    + " : " + m_jobId);
        } else {
            m_idLabel.setText(Messages.getString("session.id") + " : " + ",   "
                    + Messages.getString("job.id") + " : ");
        }
    }

    /**
     * このコンポジットが利用するテーブルビューアを返します。
     * 
     * @return テーブルビューア
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * このコンポジットが利用するテーブルを返します。
     * 
     * @return テーブル
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return m_sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        m_sessionId = sessionId;
    }

    /**
     * @return Returns the jobId.
     */
    public String getJobId() {
        return m_jobId;
    }

    /**
     * @param jobId
     *            The jobId to set.
     */
    public void setJobId(String jobId) {
        m_jobId = jobId;
    }
}