/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetCalendarIdList;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;
import com.clustercontrol.util.Messages;

/**
 * 制御コンポジットクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ControlComposite extends Composite {
	protected Button m_waitCondition = null;
	
	protected Button m_skipCondition = null;
	protected Group m_skipEndConditionGroup = null;
	protected Text m_skipEndValue = null;
	
	protected Button m_calendarCondition = null;
	protected Group m_calendarConditionGroup = null;
	protected Combo m_calendarId = null;
	protected Text m_calendarEndValue = null;
	
	protected JobWaitRuleInfo m_waitRule = null;
	
	protected Shell m_shell = null;
	
	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 * @param style
	 * @since 2.1.0
	 */
	public ControlComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
		m_shell = this.getShell();
	}
	
	/**
	 * 初期化処理
	 * 
	 * @since 2.1.0
	 */
	private void initialize() {
		RowLayout layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.spacing = 1;
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.fill = true;
		this.setLayout(layout);
		
		Composite composite = null;
		RowLayout rowLayout = null;
		
		//カレンダ
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);
		
		m_calendarCondition = new Button(composite, SWT.CHECK);
		m_calendarCondition.setText(Messages.getString("calendar"));
		m_calendarCondition.setLayoutData(new RowData(220,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_calendarCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_calendarConditionGroup.setEnabled(true);
					m_calendarId.setEnabled(true);
					m_calendarEndValue.setEnabled(true);
				} else {
					m_calendarConditionGroup.setEnabled(false);
					m_calendarId.setEnabled(false);
					m_calendarEndValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		m_calendarConditionGroup = new Group(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		m_calendarConditionGroup.setLayout(rowLayout);
		
		composite = new Composite(m_calendarConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		rowLayout.marginHeight = 2;
		composite.setLayout(rowLayout);
		Label calendarIdTitle = new Label(composite, SWT.LEFT);
		calendarIdTitle.setText(Messages.getString("calendar.id") + " : ");
		calendarIdTitle.setLayoutData(new RowData(80,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_calendarId = new Combo(composite, SWT.LEFT | SWT.READ_ONLY);
		m_calendarId.setLayoutData(new RowData(100, SizeConstant.SIZE_COMBO_HEIGHT));
		ArrayList idList = new GetCalendarIdList().getCalendarIdList();
		if(idList != null){
			for(int i = 0; i < idList.size(); i++){
				m_calendarId.add((String)idList.get(i));
			}
		}
		
		composite = new Composite(m_calendarConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		Label calendarEndValueTitle = new Label(composite, SWT.LEFT);
		calendarEndValueTitle.setText(Messages.getString("end.value") + " : ");
		calendarEndValueTitle.setLayoutData(new RowData(80,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_calendarEndValue = new Text(composite, SWT.BORDER);
		m_calendarEndValue.setLayoutData(new RowData(100, SizeConstant.SIZE_TEXT_HEIGHT));
		m_calendarEndValue.addVerifyListener(new NumberVerifyListener());
		
		
		//保留
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);
		
		Label dummy4 = new Label(composite, SWT.NONE);
		dummy4.setLayoutData(new RowData(190, SizeConstant.SIZE_LABEL_HEIGHT));
		m_waitCondition = new Button(composite, SWT.CHECK);
		m_waitCondition.setText(Messages.getString("reserve"));
		m_waitCondition.setLayoutData(new RowData(200,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_waitCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_skipCondition.setSelection(false);
					m_skipEndConditionGroup.setEnabled(false);
					m_skipEndValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		//スキップ
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);
		
		m_skipCondition = new Button(composite, SWT.CHECK);
		m_skipCondition.setText(Messages.getString("skip"));
		m_skipCondition.setLayoutData(new RowData(200,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_skipCondition.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_skipEndConditionGroup.setEnabled(true);
					m_skipEndValue.setEnabled(true);
					m_waitCondition.setSelection(false);
				} else {
					m_skipEndConditionGroup.setEnabled(false);
					m_skipEndValue.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
		
		m_skipEndConditionGroup = new Group(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		rowLayout.marginWidth = 5;
		rowLayout.marginHeight = 5;
		rowLayout.spacing = 1;
		m_skipEndConditionGroup.setLayout(rowLayout);
		
		composite = new Composite(m_skipEndConditionGroup, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 10;
		composite.setLayout(rowLayout);
		Label skipEndValueTitle = new Label(composite, SWT.LEFT);
		skipEndValueTitle.setText(Messages.getString("end.value") + " : ");
		skipEndValueTitle.setLayoutData(new RowData(80,
				SizeConstant.SIZE_LABEL_HEIGHT));
		m_skipEndValue = new Text(composite, SWT.BORDER);
		m_skipEndValue.setLayoutData(new RowData(100,
				SizeConstant.SIZE_TEXT_HEIGHT));
		m_skipEndValue.addVerifyListener(new NumberVerifyListener());
		
	}
	
	/**
	 * 待ち条件情報反映
	 *  
	 */
	@SuppressWarnings("unchecked")
	public void reflectWaitRuleInfo() {
		if (m_waitRule instanceof JobWaitRuleInfo) {
			//カレンダ
			m_calendarCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule
					.getCalendar()));
			
			//カレンダID
			if (m_waitRule.getCalendarId() != null && 
					m_waitRule.getCalendarId().length() > 0) {
				m_calendarId.select(0);
				for (int i = 0; i < m_calendarId.getItemCount(); i++) {
					if (m_waitRule.getCalendarId().equals(m_calendarId.getItem(i))) {
						m_calendarId.select(i);
						break;
					}
				}
			}
			
			//カレンダ未実行時の終了値
			m_calendarEndValue.setText(String.valueOf(m_waitRule.getCalendarEndValue()));
			
			//保留
			m_waitCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule.getSuspend()));
			
			//スキップ
			m_skipCondition.setSelection(YesNoConstant.typeToBoolean(m_waitRule.getSkip()));
			
			//スキップ終了値
			m_skipEndValue.setText(String.valueOf(m_waitRule.getSkipEndValue()));
		} else {
			m_calendarCondition.setSelection(false);
			m_calendarEndValue.setText(String
					.valueOf(EndStatusConstant.INITIAL_VALUE_NORMAL));
			m_waitCondition.setSelection(false);
			m_skipCondition.setSelection(false);
			m_skipEndValue.setText(String
					.valueOf(EndStatusConstant.INITIAL_VALUE_NORMAL));
		}
		
		//カレンダ
		if (m_calendarCondition.getSelection()) {
			m_calendarConditionGroup.setEnabled(true);
			m_calendarId.setEnabled(true);
			m_calendarEndValue.setEnabled(true);
		} else {
			m_calendarConditionGroup.setEnabled(false);
			m_calendarId.setEnabled(false);
			m_calendarEndValue.setEnabled(false);
		}
		
		//保留
		if (m_waitCondition.getSelection()) {
			m_skipCondition.setSelection(false);
		}
		
		//スキップ
		if (m_skipCondition.getSelection()) {
			m_skipEndConditionGroup.setEnabled(true);
			m_skipEndValue.setEnabled(true);
			m_waitCondition.setSelection(false);
		} else {
			m_skipEndConditionGroup.setEnabled(false);
			m_skipEndValue.setEnabled(false);
		}
	}
	
	/**
	 * 待ち条件情報設定
	 * 
	 * @param m_waitRule
	 */
	public void setWaitRuleInfo(JobWaitRuleInfo start) {
		m_waitRule = start;
	}
	
	/**
	 * 待ち条件情報取得
	 * 
	 * @return
	 */
	public JobWaitRuleInfo getWaitRuleInfo() {
		return m_waitRule;
	}
	
	/**
	 * 待ち条件情報作成
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult createWaitRuleInfo() {
		ValidateResult result = null;
		
		//実行内容情報クラスのインスタンスを作成・取得
		if (m_waitRule == null)
			m_waitRule = new JobWaitRuleInfo();
		
		//カレンダ
		m_waitRule.setCalendar(YesNoConstant.booleanToType(m_calendarCondition
				.getSelection()));
		
		//カレンダID
		if (m_calendarId.getText().length() > 0) {
			m_waitRule.setCalendarId(m_calendarId.getText());
		}
		else{
			if (m_waitRule.getCalendar() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.calendar.22"));
				return result;
			}
		}
		
		//カレンダ未実行時の終了値取得
		try {
			m_waitRule.setCalendarEndValue(Integer.parseInt(m_calendarEndValue.getText()));
		} catch (NumberFormatException e) {
			if (m_waitRule.getCalendar() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.21"));
				return result;
			}
		}
		
		//保留
		m_waitRule.setSuspend(YesNoConstant.booleanToType(m_waitCondition
				.getSelection()));
		
		//スキップ
		m_waitRule.setSkip(YesNoConstant.booleanToType(m_skipCondition
				.getSelection()));
		
		//スキップ終了値取得
		try {
			m_waitRule.setSkipEndValue(Integer.parseInt(m_skipEndValue
					.getText()));
		} catch (NumberFormatException e) {
			if (m_waitRule.getSkip() == YesNoConstant.TYPE_YES) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.21"));
				return result;
			}
		}
		
		return null;
	}
}