/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * ジョブ変数ユーティリティクラス
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ParameterUtil {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( ParameterUtil.class );
	
	/**
	 * ログ出力情報からパラメータIDに対応する値を取得します。
	 * 
	 * @param paramId パラメータID
	 * @param info ログ出力情報
	 * @return 値
	 */
	public static String getParameterValue(String paramId, LogOutputInfo info) {
		String value = null;
		
		if(info == null)
			return value;

		if(paramId.equals(SystemParameterConstant.FACILITY_ID)){
			//ファシリティID
			value = info.getFacilityId();
		}
		else if(paramId.equals(SystemParameterConstant.PLUGIN_ID)){
			//プラグインID
			value = info.getPluginId();
		}
		else if(paramId.equals(SystemParameterConstant.MONITOR_ID)){
			//監視項目ID
			value = info.getMonitorId();
		}
		else if(paramId.equals(SystemParameterConstant.MESSAGE_ID)){
			//メッセージID
			value = info.getMessageId();
		}
		else if(paramId.equals(SystemParameterConstant.APPLICATION)){
			//アプリケーション
			value = info.getApplication();
		}
		else if(paramId.equals(SystemParameterConstant.PRIORITY)){
			//重要度
			value = String.valueOf(info.getPriority());
		}
		else if(paramId.equals(SystemParameterConstant.MESSAGE)){
			//メッセージ
			value = info.getMessage();
		}
		else if(paramId.equals(SystemParameterConstant.ORG_MESSAGE)){
			//オリジナルメッセージ
			value = info.getMessageOrg();
		}

		return value;
	}
	
	/**
	 * セッションからパラメータIDに対応する値を取得します。
	 * 
	 * @param sessionId セッションID
	 * @param paramId パラメータID
	 * @return 値
	 */
	public static String getSessionParameterValue(String sessionId, String paramId) {
		String value = null;
		
		Collection collection = null;
		try {
			collection = JobParamInfoUtil.getLocalHome().findBySessionIdAndParamId(sessionId, paramId);
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		
		if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
				JobParamInfoLocal param = (JobParamInfoLocal)itr.next();
				value = param.getValue();
				break;
			}
		}
		
		return value;
	}
	
	/**
	 * 引数で指定された文字列からパラメータIDを取得し、<BR>
	 * セッションからパラメータIDに対応する値を取得します。<BR>
	 * 引数で指定された文字列のパラメータID部分を取得した値で置き換えます。
	 * 
	 * @param sessionId セッションID
	 * @param source 置き換え対象文字列
	 * @return 置き換え後の文字列
	 */
	public static String replaceSessionParameterValue(String sessionId, String source) {
		String result = source;
		
		//StreamTokenizerの初期化
		StringReader fr = new StringReader(source);
		StreamTokenizer tokenizer = new StreamTokenizer(fr);
		
		tokenizer.wordChars('\u0000', '\u00FF');
		tokenizer.whitespaceChars(' ', ' ');
		
		tokenizer.eolIsSignificant(true);
		
		int token = StreamTokenizer.TT_EOF;
		try {
			while ((token = tokenizer.nextToken()) != StreamTokenizer.TT_EOF) {
				
				if (token == StreamTokenizer.TT_WORD) {
					
					String tmpSval = tokenizer.sval;
					
					int start = tmpSval.indexOf(SystemParameterConstant.HEADER);
					int end = tmpSval.indexOf(SystemParameterConstant.FOOTER);
					if (start != -1 && 
							end != -1) {
						//パラメータID取得
						String paramId = tmpSval.substring(start + 2, end);
						
						//パラメータ値取得
						String value = getSessionParameterValue(sessionId, paramId);
						//パラメータ取得チェック
						if(value == null){
							//取得失敗なら、置き換えエラーとする
							return null;
						}
						
						//文字列内のパラメータ値を置き換え
						result = result.replaceAll(
								SystemParameterConstant.HEADER_REGEX + 
								paramId + 
								SystemParameterConstant.FOOTER_REGEX, 
								value);
					}
				}
			}
		} catch (IOException e) {
		}
		
		//"${"・"}"が含まれているかチェック
		int start = result.indexOf(SystemParameterConstant.HEADER);
		int end = result.indexOf(SystemParameterConstant.FOOTER);
		if (start != -1 && 
				end != -1) {
			//含まれていたら置き換えエラーとする
			return null;
		}
		
		return result;
	}
}
