/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.jobmanagement.util;

import java.util.Properties;

import javax.naming.InitialContext;
import javax.naming.NamingException;

/**
 * 初期化コンテキストを生成するクラスです。
 *
 * @version 1.0
 * @since 1.0
 */
public class JNDIConnectionManager {
	
	/**
	 * 初期化コンテキストを返します。<BR>
	 * マネージャがシングル構成の場合は、初期値で生成します。
	 * クラスタ構成の場合は、JNDIサービスプロバイダのURLのポートに1100を指定します。
	 * 
	 * @return 初期化コンテキスト
	 * @throws NamingException
	 */
	public static InitialContext getInitialContext() throws NamingException{
		
		InitialContext iniCtx = null;
		String serverName = System.getProperty("jboss.server.name");
		if(serverName.equals("all")){
			Properties properties = new Properties(); 
			properties.put(InitialContext.INITIAL_CONTEXT_FACTORY,"org.jnp.interfaces.NamingContextFactory");
			properties.put(InitialContext.URL_PKG_PREFIXES,"org.jboss.naming:org.jnp.interfaces");
			properties.put(InitialContext.PROVIDER_URL,"jnp://localhost:1100");
			
			iniCtx = new InitialContext(properties);
		}
		else{
			iniCtx = new InitialContext();
		}
		
		return iniCtx;
	}
}
