/*
                                                                                                                                                                 
Copyright (C) 2006 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.jobmanagement.util;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * データベースとの接続を管理するクラスです。
 *
 * @version 1.0
 * @since 1.0
 */
public class ConnectionManager {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog(ConnectionManager.class);
	
	private static ConnectionManager instance = null;
	private InitialContext ctx;
	private DataSource ds;
	
	/**
	 * 唯一の自身のインスタンスを返します。<BR>
	 * <code> DataSource </code>オブジェクトを保持します。
	 * 
	 * @return 自身のインスタンス
	 * @throws SQLException
	 */
	public synchronized static ConnectionManager getConnectionManager() throws SQLException {
		if (instance == null) {
			instance = new ConnectionManager();
		}
		return instance;
	}
	
	/**
	 * コンストラクタ。<BR>
	 * 唯一の <code>DataSource</code> オブジェクトを生成します。
	 * 
	 * @throws SQLException
	 */
	private ConnectionManager() throws SQLException {
		try {
			ctx = JNDIConnectionManager.getInitialContext();
			ds = (DataSource) ctx.lookup("java:/HinemosDS");
		} catch (NamingException e1) {
			throw new SQLException(e1.getMessage());
		}
	}
	
	/**
	 * コネクションを返します。<BR>
	 * 唯一保持する<code> DataSource </code>オブジェクトが表すデータソースへのコネクションを取得します。
	 * 
	 * @return データベースへの接続
	 * @throws SQLException
	 */
	public synchronized Connection getConnection() throws SQLException {
		return ds.getConnection();
	}
}
