/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.message;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 実行結果情報を保持するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class RunResultInfo extends RunInfo implements Serializable {
	private static final long serialVersionUID = -5920913289024178396L;
	
	/** ステータス */
    protected int status;
    /** 時刻 */
    protected Date time;
    /** ファイルリスト */
    protected List<String> fileList;
    /** 終了値 */
    protected int endValue;
    /** メッセージ */
    protected String message;    
    /** エラーメッセージ */
    protected String errorMessage;
    
    /**
     * 時刻を返します。
     * 
     * @return 時刻
     */
    public Date getTime() {
        return time;
    }
    
    /**
     * 時刻を設定します。
     * 
     * @param time 時刻
     */
    public void setTime(Date time) {
        this.time = time;
    }

    /**
     * 終了値を返します。
     * 
     * @return 終了値
     */
    public int getEndValue() {
        return endValue;
    }
    
    /**
     * 終了値を設定します。
     * 
     * @param endValue 終了値
     */
    public void setEndValue(int endValue) {
        this.endValue = endValue;
    }
    
    /**
     * エラーメッセージを返します。
     * 
     * @return エラーメッセージ
     */
    public String getErrorMessage() {
        return errorMessage;
    }
    
    /**
     * エラーメッセージを設定します。
     * 
     * @param errorMessage エラーメッセージ
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
    
    /**
     * メッセージを返します。
     * 
     * @return メッセージ
     */
    public String getMessage() {
        return message;
    }
    
    /**
     * メッセージを設定します。
     * 
     * @param message メッセージ
     */
    public void setMessage(String message) {
        this.message = message;
    }
    
    /**
     * ステータスを返します。
     * 
     * @return ステータス
     * 
     * @see com.clustercontrol.jobmanagement.bean.RunStatusConstant
     */
    public int getStatus() {
        return status;
    }
    
    /**
     * ステータスを設定します。
     * 
     * @param status ステータス
     * 
     * @see com.clustercontrol.jobmanagement.bean.RunStatusConstant
     */
    public void setStatus(int status) {
        this.status = status;
    }
    
	/**
	 * ファイルリストを返します。
	 * 
	 * @return ファイルリスト
	 */
	public List<String> getFileList() {
		return fileList;
	}
	
	/**
	 * ファイルリストを設定します。
	 * 
	 * @param fileList ファイルリスト
	 */
	public void setFileList(List<String> fileList) {
		this.fileList = fileList;
	}
}
