/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.message;

import java.io.Serializable;

/**
 * 実行情報を保持するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class RunInfo implements Serializable {
	private static final long serialVersionUID = -4752419336473888616L;
	
	/** ファシリティID */
    protected String facilityId;
    /** セッションID */
    protected String sessionId;
    /** ジョブID */
    protected String jobId;
    /** コマンドタイプ */
    protected int commandType;
    /** コマンド */
    protected String command;
    /** 実行ユーザ */
    protected String user;
    
    /** scp(ssh)公開鍵 */
    protected String publicKey;
    /** チェックサム */
    protected String checkSum;
    
    /**
     * コマンドを返します。
     * 
     * @return コマンド
     */
    public String getCommand() {
        return command;
    }
    
    /**
     * コマンドを設定します。
     * 
     * @param command コマンド
     */
    public void setCommand(String command) {
        this.command = command;
    }
    
    /**
     * コマンド種別を返します。
     * 
     * @return コマンド種別
     * 
     * @see com.clustercontrol.jobmanagement.bean.CommandTypeConstant
     */
    public int getCommandType() {
        return commandType;
    }
    
    /**
     * コマンド種別を設定します。
     * 
     * @param commandType コマンド種別
     * 
     * @see com.clustercontrol.jobmanagement.bean.CommandTypeConstant
     */
    public void setCommandType(int commandType) {
        this.commandType = commandType;
    }
    
    /**
     * ファシリティIDを返します。
     * 
     * @return ファシリティID
     */
    public String getFacilityId() {
        return facilityId;
    }
    
    /**
     * ファシリティIDを設定します。
     * 
     * @param facilityId ファシリティID
     */
    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }
    
    /**
     * ジョブIDを返します。
     * 
     * @return ジョブID
     */
    public String getJobId() {
        return jobId;
    }
    
    /**
     * ジョブIDを設定します。
     * 
     * @param jobId ジョブID
     */
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }
    
    /**
     * セッションIDを返します。
     * 
     * @return セッションID
     */
    public String getSessionId() {
        return sessionId;
    }
    
    /**
     * セッションIDを設定します。
     * 
     * @param sessionId セッションID
     */
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
    
    /**
     * 公開キーを返します。
     * 
     * @return 公開キー
     */
    public String getPublicKey() {
        return publicKey;
    }
    
    /**
     * 公開キーを設定します。
     * 
     * @param publicKey 公開キー
     */
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }
    
    /**
     * 実行ユーザを返します。
     * 
     * @return 実行ユーザ
     */
    public String getUser() {
        return user;
    }
    
    /**
     * 実行ユーザを設定します。
     * 
     * @param user 実行ユーザ
     */
    public void setUser(String user) {
        this.user = user;
    }
    
	/**
	 * チェックサムを返します。
	 * 
	 * @return チェックサム
	 */
	public String getCheckSum() {
		return checkSum;
	}
	
	/**
	 * チェックサムを設定します。
	 * 
	 * @param checkSum チェックサム
	 */
	public void setCheckSum(String checkSum) {
		this.checkSum = checkSum;
	}
}
