/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.jobmanagement.bean.DelayNotifyConstant;
import com.clustercontrol.jobmanagement.bean.EndStatusCheckConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoLocal;

/**
 * ジョブ操作の開始[即時]を行うクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateStartOfJob extends OperationJob {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( OperateStartOfJob.class );

	/**
	 * コンストラクタ
	 */
	public OperateStartOfJob(){
		super();
	}
	
	/**
	 * ジョブを開始[即時]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @throws FinderException
	 * @throws NamingException
	 * @throws EJBException
	 * @throws RemoveException
	 * 
	 * @see com.clustercontrol.jobmanagement.factory.OperationJob#setStatus(String, String, Integer)
	 * @see com.clustercontrol.jobmanagement.factory.OperationJob#startJob(String, String)
	 * @see com.clustercontrol.jobmanagement.factory.OperationJob#startJobMain1(String, String, String)
	 * @see com.clustercontrol.jobmanagement.factory.OperateStartOfJob#clearStatus(String, String, String)
	 * @see com.clustercontrol.jobmanagement.factory.Notice#notify(String, String, Integer)
	 */
	public void startJob(String sessionId, String jobId, String facilityId) throws FinderException, NamingException, EJBException, RemoveException {
		m_log.debug("startJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//ステータスクリア
		clearStatus(sessionId, jobId, facilityId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		//リレーションを取得し、親ジョブのジョブIDを取得
		JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
		String parentJobId = relation.getParent_job_id();
		relation = null;
		
		//親ジョブネットのステータスを設定
		if(parentJobId.compareTo("TOP") == 0){
			sessionJob.setStatus(new Integer(StatusConstant.TYPE_RUNNING));
			sessionJob.setStart_date(new Date());
			//通知処理
			new Notice().notify(sessionId, jobId, new Integer(EndStatusConstant.TYPE_BEGINNING));
		}
		else{
			setStatus(sessionId, parentJobId, new Integer(StatusConstant.TYPE_RUNNING));
		}
		
		//ジョブを取得
		JobInfoLocal job = sessionJob.getJobInfo();
		sessionJob = null;
		if(job.getJob_type().intValue() == JobConstant.TYPE_JOBUNIT){
			//ジョブユニットの場合、ジョブ開始処理を行う
			startJob(sessionId, jobId);
		}
		else{
			//ジョブネット、ジョブの場合、ジョブ開始処理メイン1を行う
			startJobMain1(sessionId, jobId, facilityId);
		}
	}
	
	/**
	 * ジョブの実行結果をクリアします。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param facilityId ファシリティID
	 * @throws FinderException
	 * @throws NamingException
	 * @throws EJBException
	 * @throws RemoveException
	 * 
	 * @see com.clustercontrol.jobmanagement.factory.OperationJob#clearJob(String, String)
	 */
	protected void clearStatus(String sessionId, String jobId, String facilityId) throws FinderException, NamingException, EJBException, RemoveException {
		m_log.debug("clearStatus() : sessionId=" + sessionId + ", jobId=" + jobId + ", facilityId=" + facilityId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			JobInfoLocal job = sessionJob.getJobInfo();
			JobStartInfoLocal start = job.getJobStartInfo();
			
			//終了状態、終了値、終了・中断日時、開始・再実行日時をクリア
			sessionJob.setEnd_status(null);
			sessionJob.setEnd_value(null);
			sessionJob.setEnd_date(null);
			sessionJob.setStart_date(null);
			sessionJob.setResult(null);
			sessionJob.setEnd_staus_check_flg(new Integer(EndStatusCheckConstant.NO_WAIT_JOB));
			sessionJob.setDelay_notify_flg(new Integer(DelayNotifyConstant.NONE));
			
			//開始時保留、開始時スキップをチェック
			if(start != null){
				if(start.getSuspend().intValue() == YesNoConstant.TYPE_YES){
					//JobSessionJobのステータスに保留を設定
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_RESERVING));
				}
				else if(start.getSkip().intValue() == YesNoConstant.TYPE_YES){
					//JobSessionJobのステータスにスキップを設定
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_SKIP));
					//JobSessionJobの終了値を設定
					sessionJob.setEnd_value(start.getSkip_end_value());
				}
				else{
					//JobSessionJobのステータスに待機中を設定
					sessionJob.setStatus(new Integer(StatusConstant.TYPE_WAIT));
				}
			}
			else{
				//JobSessionJobのステータスに待機中を設定
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_WAIT));
			}
			
			if(job.getJob_type().intValue() == JobConstant.TYPE_JOB){
				//ジョブの場合
				if(facilityId != null && facilityId.length() > 0){
					sessionJob = null;
					
					//ノードの場合
					JobSessionNodeLocal sessionNode = 
						JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
								new JobSessionNodePK(sessionId, jobId, facilityId));
					
					//セッションノードのステータスに待機中を設定
					sessionNode.setStatus(new Integer(StatusConstant.TYPE_WAIT));
					
					//終了値、終了・中断日時、開始・再実行日時をクリア
					sessionNode.setEnd_value(null);
					sessionNode.setEnd_date(null);
					sessionNode.setStart_date(null);
					sessionNode.setAgent_check(null);
					sessionNode.setCheck_date(null);
					sessionNode.setRetry_count(new Integer(0));
					sessionNode.setResult(null);
					sessionNode.setMessage(null);
					sessionNode.setStatus_buffer(null);
				}
				else{
					Collection collection = sessionJob.getJobSessionNode();
					sessionJob = null;
					if(collection != null && collection.size() > 0){
						Iterator itr = collection.iterator();
						while(itr.hasNext()){
							JobSessionNodeLocal sessionNode = (JobSessionNodeLocal)itr.next();
							
							//セッションノードのステータスに待機中を設定
							sessionNode.setStatus(new Integer(StatusConstant.TYPE_WAIT));
							
							//終了値、終了・中断日時、開始・再実行日時をクリア
							sessionNode.setEnd_value(null);
							sessionNode.setEnd_date(null);
							sessionNode.setStart_date(null);
							sessionNode.setAgent_check(null);
							sessionNode.setCheck_date(null);
							sessionNode.setRetry_count(new Integer(0));
							sessionNode.setResult(null);
							sessionNode.setMessage(null);
							sessionNode.setStatus_buffer(null);
						}
					}
				}
			}
			else if(job.getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
				//ジョブ以外の場合
				sessionJob = null;
				
				//セッションIDとジョブIDから、直下のジョブを取得
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
						JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
						
						if(relation.getJob_id().equals(jobId + CreateFileJob.FILE_LIST))
							//ジョブステータスクリアを行う
							clearStatus(relation.getSession_id(), relation.getJob_id(), null);
						else
							//ジョブ削除を行う
							clearJob(relation.getSession_id(), relation.getJob_id());
						
					}
				}
			}
			else{
				//ジョブ以外の場合
				sessionJob = null;
				
				//セッションIDとジョブIDから、直下のジョブを取得
				Collection collection = JobRelationInfoUtil.getLocalHome().findByParentJobId(sessionId, jobId);
				if(collection != null && collection.size() > 0){
					Iterator itr = collection.iterator();
					while(itr.hasNext()){
						JobRelationInfoLocal relation = (JobRelationInfoLocal)itr.next();
						
						//ジョブステータスクリアを行う
						clearStatus(relation.getSession_id(), relation.getJob_id(), null);
					}
				}
			}
		}
	}
	
}
