/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;

/**
 * ジョブ操作のスキップに関する処理を行うクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateSkipOfJob extends OperationJob {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( OperateSkipOfJob.class );

	/**
	 * コンストラクタ
	 */
	public OperateSkipOfJob(){
		super();
	}
	
	/**
	 * ジョブを開始[スキップ解除]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void releaseSkipJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("releaseSkipJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ステータスがスキップの場合
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_SKIP){
				//ステータスを待機中にする
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_WAIT));
				//終了値をクリア
				sessionJob.setEnd_value(null);
			}
		}
	}
	
	/**
	 * ジョブを停止[スキップ]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @param endValue 終了値
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void skipJob(
			String sessionId, 
			String jobId, 
			Integer endValue) throws FinderException, NamingException {
		
		m_log.debug("skipJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", endValue=" + endValue);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ステータスが待機中の場合、ステータスをスキップにする
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_WAIT){
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_SKIP));
				//終了値を設定
				sessionJob.setEnd_value(endValue);
			}
		}
	}
}
