/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.HashMap;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.OperationConstant;

/**
 * ジョブ操作の可否を判定するクラスです。
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobOperationJudgment {
	/** ジョブ操作の実行状態毎のパターン */
    protected static HashMap<Integer, ArrayList> m_statusPatternMap = new HashMap<Integer, ArrayList>();
    /** ジョブ操作のジョブ種別毎のパターン */
    protected static HashMap<Integer, ArrayList> m_jobPatternMap = new HashMap<Integer, ArrayList>();
    /** ジョブネット */
    public static final int TYPE_JOBNET = 0;
    /** ジョブ */
    public static final int TYPE_JOB = 1;
    /** ノード */
    public static final int TYPE_NODE = 2;
    
	static{
		// ジョブ操作の実行状態毎のパターンをハッシュに保持

	    //開始[即時]
	    ArrayList<Integer> operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_SUSPEND));
	    operation.add(new Integer(StatusConstant.TYPE_STOP));
	    operation.add(new Integer(StatusConstant.TYPE_END));
	    operation.add(new Integer(StatusConstant.TYPE_MODIFIED));
	    operation.add(new Integer(StatusConstant.TYPE_ERROR));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_AT_ONCE), operation);
	    
	    //開始[中断解除]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_SUSPEND));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_SUSPEND), operation);
	    
	    //開始[保留解除]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_RESERVING));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_WAIT), operation);
	    
	    //開始[スキップ解除]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_SKIP));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_SKIP), operation);
	    
	    //停止[即時]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_RUNNING));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_AT_ONCE), operation);
	    
	    //停止[中断]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_RUNNING));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_SUSPEND), operation);
	    
	    //停止[保留]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_WAIT));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_WAIT), operation);
	    
	    //停止[スキップ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_WAIT));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_SKIP), operation);
	    
	    //停止[メンテ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_END));
	    operation.add(new Integer(StatusConstant.TYPE_MODIFIED));
	    operation.add(new Integer(StatusConstant.TYPE_STOP));
	    operation.add(new Integer(StatusConstant.TYPE_ERROR));
	    m_statusPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_MAINTENANCE), operation);
	    
	    
		// ジョブ操作のジョブ種別毎のパターンをハッシュに保持

	    //開始[即時]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_NODE));
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_AT_ONCE), operation);
	    
	    //開始[中断解除]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_SUSPEND), operation);
	    
	    //開始[保留解除]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_WAIT), operation);
	    
	    //開始[スキップ解除]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_START_SKIP), operation);

	    //停止[即時]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_NODE));
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_AT_ONCE), operation);
	    
	    //停止[中断]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_SUSPEND), operation);
	    
	    //停止[保留]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_WAIT), operation);
	    
	    //停止[スキップ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_SKIP), operation);
	    
	    //停止[メンテ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_NODE));
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(OperationConstant.TYPE_STOP_MAINTENANCE), operation);
	}
    
	/**
	 * ジョブ操作の可/不可をジョブ種別及び実行状態のパターンに当てはめて判定します。
	 * 
	 * @param operation ジョブの操作種別
	 * @param jobType ジョブ種別
	 * @param status 実行状態
	 * @return 操作可否（true：操作可、false：操作不可）
	 * 
	 * @see com.clustercontrol.bean.StatusConstant
	 * @see com.clustercontrol.jobmanagement.bean.OperationConstant
	 */
	public static boolean judgment(int operation, int jobType, int status) {
        Integer jobOperation = new Integer(operation);
	    boolean jobCheck = false;
	    boolean statusCheck = false;
	    
	    //ジョブタイプでチェック
        ArrayList list = (ArrayList)m_jobPatternMap.get(jobOperation);
        if(list != null){
	        for(int i = 0; i < list.size(); i++){
	            if(((Integer)list.get(i)).intValue() == jobType){
	                jobCheck = true;
	                break;
	            }
	        }
        }

	    //ステータスでチェック
        list = (ArrayList)m_statusPatternMap.get(jobOperation);
        if(list != null){
	        for(int i = 0; i < list.size(); i++){
	            if(((Integer)list.get(i)).intValue() == status){
	                statusCheck = true;
	                break;
	            }
	        }
        }
        
        if(jobCheck && statusCheck){
            return true;
        }
        else{
            return false;
        }
    }
}
