/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * ジョブマスタのBMP Entity Beanです。
 * 
 * @ejb.bean name="JobMaster"
 *           jndi-name="JobMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobMasterDAOImpl
 */
public abstract class JobMasterBean implements javax.ejb.EntityBean {
	/** ジョブID */
	protected String job_id;
	/** ジョブ名 */
	protected String job_name;
	/** 設定 */
	protected String description;
	/** ジョブ種別 */
	protected Integer job_type;
	/** 作成日時 */
	protected Date reg_date;
	/** 最終更新日時 */
	protected Date update_date;
	/** 新規作成ユーザ */
	protected String reg_user;
	/** 最終更新日時 */
	protected String update_user;
	
	/**
	 * ジョブマスタを生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param job_id ジョブID
	 * @param job_name ジョブ名
	 * @param description 説明
	 * @param job_type ジョブ種別
	 * @param reg_date 作成日時
	 * @param update_date 最終更新日時
	 * @param reg_user 新規作成ユーザ
	 * @param update_user 最終更新ユーザ
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public JobMasterPK ejbCreate(
			String job_id, 
			String job_name, 
			String description, 
			Integer job_type, 
			Date reg_date, 
			Date update_date, 
			String reg_user, 
			String update_user
			) throws javax.ejb.CreateException {
		this.job_id = job_id;
		this.job_name = job_name;
		this.description = description;
		this.job_type = job_type;
		this.reg_date = reg_date;
		this.update_date = update_date;
		this.reg_user = reg_user;
		this.update_user = update_user;
		return null;
	}
	
	/**
	 * 全てのジョブマスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	/**
	 * プライマリキーに一致するジョブマスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobMasterDAOImpl#findByPrimaryKey(JobInfoPK)
	 */
	public JobMasterPK ejbFindByPrimaryKey(JobMasterPK pk) throws FinderException {
		return null;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * ジョブ名を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブ名
	 */
	public java.lang.String getJob_name() {
		return job_name;
	}
	
	/**
	 * ジョブ名を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_name ジョブ名
	 */
	public void setJob_name(java.lang.String job_name) {
		this.job_name = job_name;
	}
	
	/**
	 * 説明を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public java.lang.String getDescription() {
		return description;
	}
	
	/**
	 * 説明を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public void setDescription(java.lang.String description) {
		this.description = description;
	}
	
	/**
	 * ジョブ種別を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブ種別
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public java.lang.Integer getJob_type() {
		return job_type;
	}
	
	/**
	 * ジョブ種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_type ジョブ種別
	 * 
	 * @see com.clustercontrol.bean.JobConstant
	 */
	public void setJob_type(java.lang.Integer job_type) {
		this.job_type = job_type;
	}
	
	/**
	 * 作成日時を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 作成日時
	 */
	public java.util.Date getReg_date() {
		return reg_date;
	}
	
	/**
	 * 作成日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param reg_date 作成日時
	 */
	public void setReg_date(java.util.Date reg_date) {
		this.reg_date = reg_date;
	}
	
	/**
	 * 最終更新日時を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 最終更新日時
	 */
	public java.util.Date getUpdate_date() {
		return update_date;
	}
	
	/**
	 * 最終更新日時を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param update_date 最終更新日時
	 */
	public void setUpdate_date(java.util.Date update_date) {
		this.update_date = update_date;
	}
	
	/**
	 * 新規作成ユーザを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public java.lang.String getReg_user() {
		return reg_user;
	}
	
	/**
	 * 新規作成ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param reg_user 新規作成ユーザ
	 */
	public void setReg_user(java.lang.String reg_user) {
		this.reg_user = reg_user;
	}
	
	/**
	 * 最終更新ユーザを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 最終更新ユーザ
	 */
	public java.lang.String getUpdate_user() {
		return update_user;
	}
	
	/**
	 * 最終更新ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param update_user 最終更新ユーザ
	 */
	public void setUpdate_user(java.lang.String update_user) {
		this.update_user = update_user;
	}

	/**
	 * ジョブコマンドマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブコマンドマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobCommandMasterBean#ejbFindByPrimaryKey(JobCommandMasterPK)
	 */
    public JobCommandMasterLocal getJobCommandMaster() {
    	JobCommandMasterLocal jobCommandMaster = null;
		try {
			jobCommandMaster = JobCommandMasterUtil.getLocalHome().findByPrimaryKey(new JobCommandMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobCommandMaster;
	}
    
	/**
	 * ジョブ終了状態マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ終了状態マスタのコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobEndMasterBean#ejbFindByJobId(String)
	 */
    public Collection getJobEndMaster() {
    	Collection collection = null;
		try {
			collection = JobEndMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
    
	/**
	 * ジョブ通知マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ通知マスタのコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobNoticeMasterBean#ejbFindByJobId(String)
	 */
    public Collection getJobNoticeMaster() {
    	Collection collection = null;
		try {
			collection = JobNoticeMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}

	/**
	 * ジョブ待ち条件マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ待ち条件マスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterBean#ejbFindByPrimaryKey(JobStartMasterPK)
	 */
    public JobStartMasterLocal getJobStartMaster() {
    	JobStartMasterLocal jobStartMaster = null;
		try {
			jobStartMaster = JobStartMasterUtil.getLocalHome().findByPrimaryKey(new JobStartMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartMaster;
	}

	/**
	 * ジョブリレーションマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブリレーションマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterBean#ejbFindByJobId(java.lang.String)
	 */
    public JobRelationMasterLocal getJobRelationMaster() {
    	JobRelationMasterLocal jobRelationMaster = null;
		try {
			jobRelationMaster = JobRelationMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobRelationMaster;
	}

	/**
	 * ジョブファイル転送マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブファイル転送マスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterBean#ejbFindByPrimaryKey(JobFileMasterPK)
	 */
    public JobFileMasterLocal getJobFileMaster() {
    	JobFileMasterLocal jobFileMaster = null;
		try {
			jobFileMaster = JobFileMasterUtil.getLocalHome().findByPrimaryKey(new JobFileMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobFileMaster;
	}
    
	/**
	 * ジョブ変数マスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブ変数マスタのコレクション
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobParamMasterBean#ejbFindByJobId(String)
	 */
    public Collection getJobParamMaster() {
    	Collection collection = null;
		try {
			collection = JobParamMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
}
