/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * ジョブコマンドマスタのBMP Entity Beanです。
 * 
 * @ejb.bean name="JobCommandMaster"
 *           jndi-name="JobCommandMaster"
 *           type="BMP"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobCommandMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobCommandMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * @see com.clustercontrol.jobmanagement.dao.JobCommandMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobCommandMasterDAOImpl
 */
public abstract class JobCommandMasterBean implements javax.ejb.EntityBean {
	/** ジョブID */
	protected String job_id;
	/** ファシリティID */
	protected String facility_id;
	/** スコープ処理 */
	protected Integer process_mode;
	/** 起動コマンド */
	protected String start_command;
	/** 停止コマンド */
	protected String stop_command;
	/** 実効ユーザ */
	protected String effective_user;
	/** コマンド実行失敗時終了フラグ */
	protected Integer error_end_flg;
	/** コマンド実行失敗時終了値 */
	protected Integer error_end_value;
	/** 引数のジョブID */
	protected String argument_job_id;
	/** 引数 */
	protected String argument;
	
	/**
	 * ジョブコマンドマスタを生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param job_id ジョブID
	 * @param facility_id ファシリティID
	 * @param process_mode スコープ処理
	 * @param start_command 起動コマンド
	 * @param stop_command 停止コマンド
	 * @param effective_user 実効ユーザ
	 * @param error_end_flg コマンド実行失敗時終了フラグ
	 * @param error_end_value コマンド実行失敗時終了値
	 * @param argument_job_id 引数のジョブID
	 * @param argument 引数
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public JobCommandMasterPK ejbCreate(
			String job_id, 
			String facility_id, 
			Integer process_mode, 
			String start_command, 
			String stop_command, 
			String effective_user, 
			Integer error_end_flg, 
			Integer error_end_value, 
			String argument_job_id, 
			String argument
	) throws javax.ejb.CreateException {
		this.job_id = job_id;
		this.facility_id = facility_id;
		this.process_mode = process_mode;
		this.start_command = start_command;
		this.stop_command = stop_command;
		this.effective_user = effective_user;
		this.error_end_flg = error_end_flg;
		this.error_end_value = error_end_value;
		this.argument_job_id = argument_job_id;
		this.argument = argument;
		return null;
	}
	
	/**
	 * 全てのジョブコマンドマスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	
	/**
	 * プライマリキーに一致するジョブコマンドマスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandMasterDAOImpl#findByPrimaryKey(JobCommandMasterPK)
	 */
	public JobCommandMasterPK ejbFindByPrimaryKey(JobCommandMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * ファシリティIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public java.lang.String getFacility_id() {
		return facility_id;
	}
	
	/**
	 * ファシリティIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facility_id ファシリティID
	 */
	public void setFacility_id(java.lang.String facility_id) {
		this.facility_id = facility_id;
	}
	
	/**
	 * スコープ処理を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return スコープ処理
	 * 
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public java.lang.Integer getProcess_mode() {
		return process_mode;
	}
	
	/**
	 * スコープ処理を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param process_mode スコープ処理
	 * 
	 * @see com.clustercontrol.bean.ProcessingMethodConstant
	 */
	public void setProcess_mode(java.lang.Integer process_mode) {
		this.process_mode = process_mode;
	}
	
	/**
	 * 起動コマンドを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 起動コマンド
	 */
	public java.lang.String getStart_command() {
		return start_command;
	}
	
	/**
	 * 起動コマンドを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param start_command 起動コマンド
	 */
	public void setStart_command(java.lang.String start_command) {
		this.start_command = start_command;
	}
	
	/**
	 * 停止コマンドを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 停止コマンド
	 */
	public java.lang.String getStop_command() {
		return stop_command;
	}
	
	/**
	 * 停止コマンドを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param stop_command 停止コマンド
	 */
	public void setStop_command(java.lang.String stop_command) {
		this.stop_command = stop_command;
	}
	
	/**
	 * 実効ユーザを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 実効ユーザ
	 */
	public java.lang.String getEffective_user() {
		return effective_user;
	}
	
	/**
	 * 実効ユーザを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param effective_user 実効ユーザ
	 */
	public void setEffective_user(java.lang.String effective_user) {
		this.effective_user = effective_user;
	}
	
	/**
	 * コマンド実行失敗時終了フラグを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return コマンド実行失敗時終了フラグ
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public java.lang.Integer getError_end_flg() {
		return error_end_flg;
	}
	
	/**
	 * コマンド実行失敗時終了フラグを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param error_end_flg コマンド実行失敗時終了フラグ
	 * 
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public void setError_end_flg(java.lang.Integer error_end_flg) {
		this.error_end_flg = error_end_flg;
	}
	
	/**
	 * コマンド実行失敗時終了値を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return コマンド実行失敗時終了値
	 */
	public java.lang.Integer getError_end_value() {
		return error_end_value;
	}
	
	/**
	 * コマンド実行失敗時終了値を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param error_end_value コマンド実行失敗時終了値
	 */
	public void setError_end_value(java.lang.Integer error_end_value) {
		this.error_end_value = error_end_value;
	}
	
	/**
	 * 引数のジョブIDを返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 引数のジョブID
	 */
	public java.lang.String getArgument_job_id() {
		return argument_job_id;
	}
	
	/**
	 * 引数のジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param argument_job_id 引数のジョブID
	 */
	public void setArgument_job_id(java.lang.String argument_job_id){
		this.argument_job_id = argument_job_id;
	}
	
	/**
	 * 引数を返す。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 * 
	 * @return 引数
	 */
	public java.lang.String getArgument() {
		return argument;
	}
	
	/**
	 * 引数を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param argument 引数
	 */
	public void setArgument(java.lang.String argument) {
		this.argument = argument;
	}
	
	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
}
