/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.core;

import org.eclipse.ui.plugin.*;
import org.osgi.framework.BundleContext;
import java.util.*;

/**
 * ジョブ管理コアプラグインクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 * @see org.eclipse.ui.plugin.AbstractUIPlugin
 */
public class JobManagementCorePlugin extends AbstractUIPlugin {
	
	/** プラグインインスタンス */
	private static JobManagementCorePlugin plugin;
	/** リソースバンドルインスタンス */
	private ResourceBundle resourceBundle;
	
	/**
	 * コンストラクタ<BR>
	 * リソースバンドルを取得する
	 */
	public JobManagementCorePlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("com.clustercontrol.jobmanagement.core.JobManagementCorePluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	
	/**
	 * プラグイン 開始
	 * 
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	
	/**
	 * プラグイン 停止
	 * 
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}
	
	/**
	 * ジョブ管理コアプラグインのインスタンスを返します。
	 * 
	 * @return ジョブ管理コアプラグインのインスタンス
	 */ 
	public static JobManagementCorePlugin getDefault() {
		return plugin;
	}
	
	/**
	 * ジョブ管理コアプラグインのリソースバンドルから、
	 * キーに該当する文字列を返します。
	 * 
	 * @param key キー
	 * @return 文字列
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = JobManagementCorePlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/**
	 * ジョブ管理コアプラグインのリソースバンドルを返します。
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
