/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * ジョブ管理プラグインクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 * 
 * @see org.eclipse.ui.plugin.AbstractUIPlugin
 */
public class JobManagementPlugin extends AbstractUIPlugin {
	
	/** プラグインインスタンス */
	private static JobManagementPlugin plugin;
	
	/** リソースバンドルインスタンス */
	private ResourceBundle resourceBundle;
	
	/**
	 * コンストラクタ<BR>
	 * リソースバンドルを取得する
	 */
	public JobManagementPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle
			.getBundle("com.clustercontrol.jobmanagement.JobManagementPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	
	/**
	 * プラグイン 開始
	 * 
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}
	
	/**
	 * プラグイン 停止
	 * 
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}
	
	/**
	 * ジョブ管理プラグインのインスタンスを返します。
	 * 
	 * @return ジョブ管理プラグインのインスタンス
	 */ 
	public static JobManagementPlugin getDefault() {
		return plugin;
	}
	
	/**
	 * ジョブ管理プラグインのリソースバンドルから、
	 * キーに該当する文字列を返します。
	 * 
	 * @param key キー
	 * @return 文字列
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = JobManagementPlugin.getDefault()
		.getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/**
	 * ジョブ管理プラグインのリソースバンドルを返します。
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}