/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.http.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.ParseException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.util.EjbConnectionManager;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * HTTP監視情報を登録するクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddHttp {

    /**
     * HTTP監視情報を追加します。
     * 
     * @param info HTTP監視情報
     * @return 登録に成功した場合、true
     */
    public boolean add(MonitorInfo info) {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

        boolean result = false;
        try {
        	result = http.addHttp(info);
        	return result;
        } catch (InvalidTransactionException e) {
		} catch (IllegalStateException e) {
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (SchedulerException e) {
		} catch (ParseException e) {
		} catch (NamingException e) {
		} catch (HeuristicMixedException e) {
		} catch (HeuristicRollbackException e) {
		} catch (RollbackException e) {
		} catch (SystemException e) {
		} catch (NotSupportedException e) {
		}
        return false;
    }
}