/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.dialog;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.hinemosagent.action.GetAgent;
import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorBlockComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.TruthRunJobComposite;
import com.clustercontrol.monitor.run.composite.TruthValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.util.Messages;

/**
 * Hinemos Agent監視作成・変更ダイアログクラスです。
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class AgentCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance フィールド ----- //

    /** 入力値を保持するオブジェクト */
    private MonitorInfo inputData = null;

    /** 入力値の正当性を保持するオブジェクト */
    private ValidateResult validateResult = null;
    
    /** 変更対象の監視項目ID */
    private String monitorId = null;
    
    /** 監視基本情報 */
    private MonitorBasicScopeComposite m_monitorBasic = null;
    
    /** 監視条件 共通部分 */
    private MonitorRuleComposite m_monitorRule = null;
    
    /** 真偽値監視判定情報 */
    private TruthValueInfoComposite m_truthValueInfo= null;

    /** ジョブエージェント */
    private Button m_checkJobAgent = null;
    
    /** ログ転送エージェント */
    private Button m_checkLogAgent = null;
    
    /** 監視単位 */
    private MonitorBlockComposite m_monitorBlock = null;
    
    /** 通知情報 */
    private NotifyInfoComposite notifyInfo = null;
    
    /** ジョブ実行 */
    private Button m_checkJobRun = null;
    
    /** ジョブ実行情報 */
    private TruthRunJobComposite m_jobRun = null;

    /** この設定を有効にする */
    private Button confirmValid = null;

    // ----- コンストラクタ ----- //

    /**
     * 作成用ダイアログのインスタンスを返します。
     * 
     * @param parent
     *            親のシェルオブジェクト
     */
    public AgentCreateDialog(Shell parent) {
        super(parent);
    }

    /**
     * 変更用ダイアログのインスタンスを返します。
     * 
     * @param parent
     *            親のシェルオブジェクト
     * @param notifyId
     *            変更する通知ID
     */
    public AgentCreateDialog(Shell parent, String monitorId) {
        super(parent);

        this.monitorId = monitorId;
    }

    // ----- instance メソッド ----- //

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent
     *            親のインスタンス
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages.getString("dialog.agent.create.modify"));

        // 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        // 監視基本情報
        m_monitorBasic = new MonitorBasicScopeComposite(parent, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorBasic.setLayoutData(gridData);
        
        /*
         * 監視条件グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.rule") + " : ");
        
        // グループ
        Group groupRule = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData(gridData);

        m_monitorRule = new MonitorRuleComposite(groupRule, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorRule.setLayoutData(gridData);
        
        
        /*
         * チェック条件グループ
         */
        // ラベル
        label = new Label(groupRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("check.rule") + " : ");
        
        // グループ
        Group groupCheckRule = new Group(groupRule, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData(gridData);
        
        /*
         * ジョブエージェント
         */
        // チェックボックス
        this.m_checkJobAgent = new Button(groupCheckRule, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE + WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkJobAgent.setLayoutData(gridData);
        this.m_checkJobAgent.setText(Messages.getString("job.agent"));
        
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ログ転送エージェント
         */
        // チェックボックス
        this.m_checkLogAgent = new Button(groupCheckRule, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE + WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_checkLogAgent.setLayoutData(gridData);
        this.m_checkLogAgent.setText(Messages.getString("log.agent"));
        
        // 空白
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * 監視単位グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.block") + " : ");
        
        // グループ
        Group groupMonitorBlock = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupMonitorBlock.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupMonitorBlock.setLayoutData(gridData);
        
        // 監視単位情報
        m_monitorBlock = new MonitorBlockComposite(groupMonitorBlock, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorBlock.setLayoutData(gridData);
        
		/*
         * ノード単位の結果判定の定義グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("def.result.node") + " : ");
        
        // グループ
        Group groupDefResultNode = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupDefResultNode.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupDefResultNode.setLayoutData(gridData);
        
        // 真偽値判定定義情報
        m_truthValueInfo = new TruthValueInfoComposite(groupDefResultNode, 
        		SWT.NONE,
        		true,
        		Messages.getString("OK"),
        		Messages.getString("NG"));
        gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_truthValueInfo.setLayoutData(gridData);
		
		/*
         * 通知情報の属性グループ
         */
        // ラベル
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.attribute") + " : ");
        
        // グループ
        Group groupNotifyAttribute = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData(gridData);
        
        // 通知情報（通知ID，アプリケーションID）
		this.notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		notifyInfo.setLayoutData(gridData);
		
		// ジョブ実行
        this.m_checkJobRun = new Button(groupNotifyAttribute, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_checkJobRun.setLayoutData(gridData);
        m_checkJobRun.setText(Messages.getString("run") + " : ");
        m_checkJobRun.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	m_jobRun.setEnabled(m_checkJobRun.getSelection());
            }
        });
		
		// ジョブ実行グループ
        Group groupRunJob = new Group(groupNotifyAttribute, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRunJob.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData(gridData);
        
        // 実行（実行，ジョブID，通知抑制と連動，呼出失敗時）
		this.m_jobRun = new TruthRunJobComposite(
				groupRunJob, 
				SWT.NONE, 
				Messages.getString("OK"),
        		Messages.getString("NG"));
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_jobRun.setLayoutData(gridData);
		
        /*
         * 有効／無効
         */
        this.confirmValid = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData(gridData);
        this.confirmValid.setText(Messages.getString("setting.valid.confirmed"));
        
        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData(gridData);


        // サイズを最適化
        // グリッドレイアウトを用いた場合、こうしないと横幅が画面いっぱいになります。
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // 通知IDが指定されている場合、その情報を初期表示する。
        MonitorInfo info = null; 
        if(this.monitorId != null){
        	info = new GetAgent().getAgent(this.monitorId);        	
        }
        else{
        	info = new MonitorInfo();
        }
        this.setInputData(info);
        
    }

    /**
     * 入力内容を返します。
     * 
     * @return 入力内容を保持した通知情報
     */
    public MonitorInfo getInputData() {
        return this.inputData;
    }

    /**
     * 各項目に入力値を設定します。
     * 
     * @param monitor
     *            設定値として用いる通知情報
     */
    protected void setInputData(MonitorInfo monitor) {

        this.inputData = monitor;
        
        // 監視基本情報
        m_monitorBasic.setInputData(monitor);
        
        // 監視条件
        m_monitorRule.setInputData(monitor);
        
        // 監視条件 Agent監視情報
        MonitorAgentInfo agentInfo = (MonitorAgentInfo)monitor.getCheckInfo();
        if(agentInfo == null){
        	agentInfo = new MonitorAgentInfo();
        }
        //ジョブエージェント
        this.m_checkJobAgent.setSelection(YesNoConstant.typeToBoolean(agentInfo.getCheckJobAgent().intValue()));
        //ログ転送エージェント
        this.m_checkLogAgent.setSelection(YesNoConstant.typeToBoolean(agentInfo.getCheckLogAgent().intValue()));
        
        // 監視単位
        m_monitorBlock.setInputData(monitor);
        
        // ノード単位の結果判定の定義
        m_truthValueInfo.setInputData(monitor);
    	
        // 通知情報の属性
        if (monitor.getNotifyId() != null) {
        	this.notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
        	this.notifyInfo.setApplication(monitor.getApplication());
        }
        
        // ジョブ実行
        m_checkJobRun.setSelection(YesNoConstant.typeToBoolean(monitor.getJobRun()));
        
        // 各重要度のジョブ実行
        m_jobRun.setInputData(monitor);
        m_jobRun.setEnabled(YesNoConstant.typeToBoolean(monitor.getJobRun()));
        
        // 有効／無効
        if (monitor.getValid() == ValidConstant.TYPE_VALID) {
            this.confirmValid.setSelection(true);
        }
    }

    /**
     * 入力値を用いて通知情報を生成します。
     * 
     * @return 入力値を保持した通知情報
     */
    protected MonitorInfo createInputData() {
    	MonitorInfo info = new MonitorInfo();

    	info.setMonitorTypeId(MonitorConstant.STRING_AGENT);
    	info.setMonitorType(MonitorTypeConstant.TYPE_TRUTH);
    	
    	// 監視基本情報
    	validateResult = m_monitorBasic.createInputData(info);
    	if(validateResult != null){
        	return null;
        }
        
        // 監視条件 共通部分
        validateResult = m_monitorRule.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        MonitorAgentInfo agentInfo = new MonitorAgentInfo();
		agentInfo.setMonitorTypeId(MonitorConstant.STRING_AGENT);
        agentInfo.setMonitorId(info.getMonitorId());
    	if (!this.m_checkJobAgent.getSelection() && !this.m_checkLogAgent.getSelection()) {
    		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.agent.8"));
            return null;
    	}
        agentInfo.setCheckJobAgent(YesNoConstant.booleanToType(this.m_checkJobAgent.getSelection()));
        agentInfo.setCheckLogAgent(YesNoConstant.booleanToType(this.m_checkLogAgent.getSelection()));
        info.setCheckInfo((MonitorCheckInfo)agentInfo);
        
        // 監視単位
        validateResult = m_monitorBlock.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // ノード単位の結果判定の定義
        validateResult = m_truthValueInfo.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // 通知情報の属性
        if (this.notifyInfo.getText() != null
                && !"".equals((this.notifyInfo.getText()).trim())) {
        	info.setNotifyId(notifyInfo.getText());
        }
//        else{
//        	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.9"));
//            return null;
//        }
        if (this.notifyInfo.getApplication() != null
                && !"".equals((this.notifyInfo.getApplication()).trim())) {
        	info.setApplication(notifyInfo.getApplication());
        }
        else{
        	if (this.notifyInfo.getText() != null
                    && !"".equals((this.notifyInfo.getText()).trim())) {
        		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
                return null;	
        	}
        }
        
        // ジョブ実行
        info.setJobRun(YesNoConstant.booleanToType(m_checkJobRun.getSelection()));
        
        // 各重要度のジョブ実行
        validateResult = m_jobRun.createInputData(info);
        if(validateResult != null){
        	return null;
        }
        
        // 有効/無効
        if (this.confirmValid.getSelection()) {
        	info.setValid(ValidConstant.TYPE_VALID);
        } else {
        	info.setValid(ValidConstant.TYPE_INVALID);
        }

        return info;
    }

    /**
     * 入力値チェックをします。
     * 
     * @return 検証結果
     */
    protected ValidateResult validate() {
        // 入力値生成
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }

    /**
     * ＯＫボタンのテキストを返します。
     * 
     * @return ＯＫボタンのテキスト
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * キャンセルボタンのテキストを返します。
     * 
     * @return キャンセルボタンのテキスト
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /**
     * 無効な入力値の情報を設定します
     *  
     */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}