/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoLocal;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoPK;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoUtil;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.factory.SelectMonitorTruthValueType;

/**
 * Hinemos Agent監視判定情報検索クラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class SelectMonitorAgent extends SelectMonitorTruthValueType{
	
	protected static Log m_log = LogFactory.getLog( SelectMonitorAgent.class );

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.SelectMonitor#getCheckInfo()
	 */
	@Override
	public MonitorCheckInfo getCheckInfo() throws FinderException, NamingException{
		// Agent監視情報を取得
		MonitorAgentInfoPK pk = new MonitorAgentInfoPK(m_monitorId, m_monitorTypeId);
		MonitorAgentInfoLocal agentLocal = MonitorAgentInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		MonitorAgentInfo agent = new MonitorAgentInfo();
		agent.setMonitorTypeId(m_monitorTypeId);
		agent.setMonitorId(m_monitorId);
		agent.setCheckJobAgent(agentLocal.getCheckJobAgent());
		agent.setCheckLogAgent(agentLocal.getCheckLogAgent());
		
		return (MonitorCheckInfo)agent;
	}
}
