/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.factory;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.hinemosagent.bean.MonitorAgentInfo;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoLocal;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoPK;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifyMonitorTruthValueType;

/**
 * Hinemos Agent監視情報更新クラス
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class ModifyMonitorAgent extends ModifyMonitorTruthValueType{
	
	protected static Log m_log = LogFactory.getLog( ModifyMonitorAgent.class );
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.ModifyMonitor#modifyCheckInfo()
	 */
	@Override
	public boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
		
		// Agent監視情報を取得
		MonitorAgentInfoPK pk = new MonitorAgentInfoPK(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		MonitorAgentInfoLocal agentLocal = MonitorAgentInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// Agent監視情報を設定
		MonitorAgentInfo agent = (MonitorAgentInfo)m_monitorInfo.getCheckInfo();
		agentLocal.setCheckJobAgent(agent.getCheckJobAgent());
		agentLocal.setCheckLogAgent(agent.getCheckLogAgent());
		
		return true;
	}
}