/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.hinemosagent.factory.AddMonitorAgent;
import com.clustercontrol.hinemosagent.factory.DeleteMonitorAgent;
import com.clustercontrol.hinemosagent.factory.ModifyMonitorAgent;
import com.clustercontrol.hinemosagent.factory.SelectMonitorAgent;
import com.clustercontrol.monitor.run.bean.MonitorInfo;

/**
 * @ejb.bean name="MonitorAgentController"
 *           jndi-name="MonitorAgentController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 */
public abstract class MonitorAgentControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorAgentControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * Hinemos Agent監視情報を登録します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AgentMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param info 通知情報
	 * @return 登録に成功した場合、true
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws SystemException
	 */
	public boolean addAgent(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();

		// Hinemos Agent監視情報を登録
		AddMonitorAgent agent = new AddMonitorAgent();
		return  agent.add(info, pri.getName());
	}
	
	/**
	 * Hinemos Agent監視情報を更新します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AgentMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param info 通知情報
	 * @return 変更に成功した場合、true
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws SystemException
	 */
	public boolean modifyAgent(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();

		// Hinemos Agent監視情報を更新
		ModifyMonitorAgent agent = new ModifyMonitorAgent();
		return  agent.modify(info, pri.getName());
	}
	
	/**
	 * Hinemos Agent監視情報を削除します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AgentMonitorWrite"
     *     method-intf="Remote"
	 * 
	 * @param monitorId 監視項目ID
	 * @return 削除に成功した場合、true
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws SystemException
	 */
	public boolean deleteAgent(String monitorId) throws InvalidTransactionException, IllegalStateException, FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {

		// Hinemos Agent監視情報を削除
		DeleteMonitorAgent agent = new DeleteMonitorAgent();
		return  agent.delete(MonitorConstant.STRING_AGENT, monitorId);
	}
	
	/**
	 * Hinemos Agent監視情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AgentMonitorRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param monitorId 状態監視ID
	 * @return Hinemos Agent監視情報
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public MonitorInfo getAgentInfo(String monitorId) throws CreateException, FinderException, SchedulerException, NamingException {

		// Hinemos Agent監視情報を取得
		SelectMonitorAgent agent = new SelectMonitorAgent();
		MonitorInfo info = agent.getMonitor(MonitorConstant.STRING_AGENT, monitorId);

		return info;
	}

	/**
	 * Hinemos Agent監視一覧リストを返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="AgentMonitorRead"
     *     method-intf="Remote"
     *     
     * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Objectの2次元配列
	 * @throws NamingException 
	 * @throws SchedulerException 
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public ArrayList getAgentList() throws CreateException, FinderException, SchedulerException, NamingException {

		// Hinemos Agent監視一覧を取得
		SelectMonitorAgent agent = new SelectMonitorAgent();
		ArrayList list = agent.getMonitorList(MonitorConstant.STRING_AGENT);

		return list;
	}
	
	/**
	 * Hinemos Agent監視一覧のテーブル定義情報を返します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local ロケール
	 * @return TableColumnInfoの配列
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getAgentListTableDefine(Locale local) {
		
		/** テーブル情報定義配列 */
		SelectMonitorAgent agent = new SelectMonitorAgent();
		ArrayList tableDefine = agent.getMonitorListTableDefine(local);

		return tableDefine;
	}
}
