/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;

import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.CommandComposite;
import com.clustercontrol.collectiverun.composite.CommandParameterComposite;
import com.clustercontrol.collectiverun.composite.ParameterComposite;
import com.clustercontrol.collectiverun.composite.ParameterSelectComposite;
import com.clustercontrol.collectiverun.composite.TypeComposite;
import com.clustercontrol.collectiverun.dialog.SetMasterDialog;
import com.clustercontrol.util.Messages;

/**
 * 一括制御ツリーのSelectionChangedListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TreeSelectionChangedListener implements
        ISelectionChangedListener {
    
	protected SetMasterDialog dialog;

    /**
     * コンストラクタ
     * 
     * @param composite
     */
    public TreeSelectionChangedListener(SetMasterDialog dialog) {
        this.dialog = dialog;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        //選択アイテムを取得
    	TreeItem selectItem = (TreeItem) ((StructuredSelection) event
    			.getSelection()).getFirstElement();
    	
    	//作成中のアイテムが存在するかチェック
    	if(this.dialog.getTree().getCreateItem() != null && 
    			this.dialog.getTree().getCreateItem() != selectItem){
    		//作成中アイテムが存在する場合
    		
    		TreeItem createItem = this.dialog.getTree().getCreateItem();
			TreeItem parent = createItem.getParent();
    		
    		//削除確認ダイアログを生成
    		MessageBox box = new MessageBox(this.dialog.getShell(),
    				SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
    		box.setText(Messages.getString("confirmed"));
            Object[] args = { createItem.getInfo().getName() };
            box.setMessage(Messages.getString("message.collective.run.8", args));
    		if (box.open() == SWT.OK) {
    			parent.removeChildren(createItem);
    			this.dialog.getTree().setCreateItem(null);
    			this.dialog.getTree().setUpdateItem(null);
    			
    			this.dialog.getTree().getTreeViewer().refresh(parent);
    			this.dialog.getTree().getTreeViewer().setSelection(
    					new StructuredSelection(selectItem), true);
    		}
    		else{
    			this.dialog.getTree().getTreeViewer().setSelection(
    					new StructuredSelection(createItem), true);
    		}
    		return;
    	}
    	
    	//更新中のアイテムが存在するかチェック
    	if(this.dialog.getTree().getUpdateItem() != null && 
    			this.dialog.getTree().getUpdateItem() != selectItem){
    		//更新中アイテムが存在する場合
    		
    		TreeItem updateItem = this.dialog.getTree().getUpdateItem();
    		
    		//削除確認ダイアログを生成
    		MessageBox box = new MessageBox(this.dialog.getShell(),
    				SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
    		box.setText(Messages.getString("confirmed"));
            Object[] args = { updateItem.getInfo().getName() };
            box.setMessage(Messages.getString("message.collective.run.9", args));
            if (box.open() == SWT.OK) {
    			this.dialog.getTree().setUpdateItem(null);
    			
    			this.dialog.getTree().getTreeViewer().setSelection(
    					new StructuredSelection(selectItem), true);
    		}
    		else{
    			this.dialog.getTree().getTreeViewer().setSelection(
    					new StructuredSelection(updateItem), true);
    		}
    		return;
    	}

        if (selectItem instanceof TreeItem) {
        	
        	if(selectItem.equals(this.dialog.getTree().getSelectItem()))
        		return;
        	
        	ItemInfo info = selectItem.getInfo();
        	//選択ツリーアイテムを設定
        	this.dialog.getTree().setSelectItem(selectItem);
        	if(info.getType() == ItemConstant.TYPE_TYPE){
        		this.dialog.setDetail(new TypeComposite(this.dialog.getParentComposite(), SWT.NONE, this.dialog.getTree()));
        	}
        	else if(info.getType() == ItemConstant.TYPE_COMMAND){
        		this.dialog.setDetail(new CommandComposite(this.dialog.getParentComposite(), SWT.NONE, this.dialog.getTree()));
        	}
         	else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
        		this.dialog.setDetail(new CommandParameterComposite(this.dialog.getParentComposite(), SWT.NONE, this.dialog.getTree()));
        	}
         	else if(info.getType() == ItemConstant.TYPE_PARAMETER){
        		this.dialog.setDetail(new ParameterComposite(this.dialog.getParentComposite(), SWT.NONE, this.dialog.getTree()));
        	}
         	else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
        		this.dialog.setDetail(new ParameterSelectComposite(this.dialog.getParentComposite(), SWT.NONE, this.dialog.getTree()));
        	}
        	else{
        		this.dialog.setDetail(new Composite(this.dialog.getParentComposite(), SWT.NONE));
        	}
        } else {
        	this.dialog.setDetail(new Composite(this.dialog.getParentComposite(), SWT.NONE));
        	
            //選択ツリーアイテムを設定
        	this.dialog.getTree().setSelectItem(null);
        }
    }
}