/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MessageBox;

import com.clustercontrol.collectiverun.action.DeleteMaster;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.util.Messages;

/**
 * 一括制御階層ツリー削除のSelectionListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteTreeItemSelectionListener extends BaseTreeItemSelectionListener {

    /**
     * コンストラクタ
     * 
     * @param composite
     */
    public DeleteTreeItemSelectionListener(TreeComposite composite) {
    	super(composite);
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
    	
    	//作成中アイテムのチェック
    	if(!checkCreateItem())
    		return;
    	
    	//更新中アイテムのチェック
    	if(!checkUpdateItem())
    		return;
    	
    	TreeItem item = this.composite.getSelectItem();
    	
    	if (item instanceof TreeItem) {
    		
    		TreeItem parent = item.getParent();
    		
    		ItemInfo info = item.getInfo();
    		ItemInfo parentInfo = parent.getInfo();
    		
    		if(info.getType() == ItemConstant.TYPE_COMMADN_COMPOSITE || 
    				info.getType() == ItemConstant.TYPE_PARAMETER_COMPOSITE){
    			return ;
    		}
    		
            // 確認ダイアログを生成
            MessageBox box = new MessageBox(this.composite.getShell(),
                    SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
            box.setText(Messages.getString("confirmed"));
            Object[] args = { item.getInfo().getName() };
            box.setMessage(Messages.getString("message.collective.run.10", args));
            if (box.open() == SWT.OK) {
            	DeleteMaster delete = new DeleteMaster();
            	if(delete.delete(info, parentInfo)){
        			parent.removeChildren(item);
        			this.composite.setCreateItem(null);

        			this.composite.getTreeViewer().refresh(parent);
        			this.composite.getTreeViewer().setSelection(
        					new StructuredSelection(parent), true);
            	}
            	else{
        			this.composite.getTreeViewer().refresh(parent);
        			this.composite.getTreeViewer().setSelection(
        					new StructuredSelection(item), true);
            	}
            }
    	}
    	
    }
}

