/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.bean;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.collectiverun.ui.CollectiveRunUIPlugin;

/**
 * 一括制御イメージ定数クラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ItemImageConstant extends ItemConstant {
    private static Image composite = null;
    
    private static Image commandComposite = null;
    
    private static Image parameterComposite = null;

    private static Image type = null;

    private static Image command = null;
    
    private static Image parameter = null;

    private static Image selectItem = null;

    /**
     * 種別からImageに変換する
     * 
     * @param itemType
     * @return
     */
    public static Image typeToImage(int itemType) {
        ImageRegistry registry = CollectiveRunUIPlugin.getDefault()
                .getImageRegistry();

        if (itemType == TYPE_COMPOSITE) {
            if (composite == null)
            	composite = registry.getDescriptor(
                        CollectiveRunUIPlugin.IMG_COMPOSITE).createImage();
            return composite;
        } else if (itemType == TYPE_COMMADN_COMPOSITE) {
            if (commandComposite == null)
            	commandComposite = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_COMMAND_COMPOSITE).createImage();
            return commandComposite;
        } else if (itemType == TYPE_PARAMETER_COMPOSITE) {
            if (parameterComposite == null)
            	parameterComposite = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_PARAMETER_COMPOSITE).createImage();
            return parameterComposite;
        } else if (itemType == TYPE_TYPE) {
            if (type == null)
            	type = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_TYPE).createImage();
            return type;
        } else if (itemType == TYPE_COMMAND) {
            if (command == null)
            	command = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_COMMAND).createImage();
            return command;
        } else if (itemType == TYPE_COMMAND_PARAMETER) {
            if (parameter == null)
            	parameter = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_PARAMETER).createImage();
            return parameter;
        } else if (itemType == TYPE_PARAMETER) {
            if (parameter == null)
            	parameter = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_PARAMETER).createImage();
            return parameter;
        } else if (itemType == TYPE_SELECT_ITEM) {
            if (selectItem == null)
            	selectItem = registry.getDescriptor(
            			CollectiveRunUIPlugin.IMG_SELECT_ITEM).createImage();
            return selectItem;
        }
        
        return null;
    }
}