/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * 履歴検索クラス
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectSession {
    protected static Log m_log = LogFactory.getLog( SelectSession.class );

    private final static int MAX_DISPLAY_NUMBER = 500;
    
	/**
	 * 履歴一覧取得
	 * 
	 * @param locale
	 * @param histories
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ViewListInfo getHistoryList(Locale locale, int histories) throws FinderException, NamingException {
		
		ViewListInfo list = new ViewListInfo();
		ArrayList history = new ArrayList();
		int total = 0;
		
		if(histories <= 0){
			histories = MAX_DISPLAY_NUMBER;
		}
		Integer limit = new Integer(histories + 1);
	    
	    //全セッションを取得
	    Collection sessionList = 
	        CRunSessionUtil.getLocalHome().selectHistoryFilter(
	                null, 
	                null, 
	                null, 
	                null, 
	                null, 
	                null, 
	                limit);
	    
	    if(sessionList != null){
	    	
			//履歴数をカウント
			if(sessionList.size() > histories){
				//最大表示件数より大きい場合
				Collection allHistory = CRunSessionUtil.getLocalHome().selectHistoryFilter(null, null, null, null, null, null, null); 
				total = allHistory.size();
				
			} else {
				total = sessionList.size();
			}

	        Iterator itr = sessionList.iterator();
			while(itr.hasNext()){
			    //セッションを取得
			    CRunSessionLocal session = (CRunSessionLocal)itr.next();
			    CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                } catch (FinderException e) {
                    
                }
                
                //履歴一覧の１行を作成
			    ArrayList info = new ArrayList();
			    info.add(session.getStatus());
			    info.add(session.getSession_id());
			    info.add(session.getStart_date());
			    info.add(session.getEnd_date());
			    
			    String name = SelectMaster.typeIdToString(session.getType_id(), locale);
			    if(name != null){
			        info.add(name);
			    }
			    else{
			        info.add("");
			    }

			    if(cmd != null){
			        info.add(Messages.getString(cmd.getName_id(), locale));
			    }
			    else{
			        info.add("");
			    }
			    info.add(session.getFacility_id());
			    info.add(session.getScope_text());
			    info.add(session.getNode_cnt());
			    info.add(session.getEnd_nomal_cnt());
			    info.add(session.getEnd_warning_cnt());
			    info.add(session.getEnd_abnomal_cnt());
			    info.add(session.getWait_cnt());
			    info.add(session.getRunning_cnt());
			    history.add(info);
			    
				//取得した履歴を最大表示件数まで格納したら終了
				if(history.size() >= histories)
					break;
			}
	    }
	    list.setTotal(total);
	    list.setList(history);
	    
	    return list;
	}
	
	/**
	 * 履歴一覧取得
	 * 
	 * @param property
	 * @param locale
	 * @param histories
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ViewListInfo getHistoryList(Property property, Locale locale, int histories) throws FinderException, NamingException {
	    
		ArrayList values = null;
		//開始・再実行日時（自）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_FROM_DATE);
		Date startFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    startFromDate = (Date)values.get(0);
		}
		//開始・再実行日時（至）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_TO_DATE);
		Date startToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    startToDate = (Date)values.get(0);
		}
		//終了・中断日時（自）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_FROM_DATE);
		Date endFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    endFromDate = (Date)values.get(0);
		}
		//終了・中断日時（至）取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_TO_DATE);
		Date endToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    endToDate = (Date)values.get(0);
		}

		//管理種別取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.TYPE);
		String type = null;
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
		    String typeString = (String)values.get(0);
		    type = SelectMaster.stringToTypeId(typeString, locale);
		}
		//状態取得
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.STATUS);
		Integer status = null;
		if(values.get(0) instanceof String){
		    String statusString = (String)values.get(0);
		    status = new Integer(StatusConstant.stringToType(statusString));
		}
		
		ViewListInfo list = new ViewListInfo();
		ArrayList history = new ArrayList();
		int total = 0;
		
		if(histories <= 0){
			histories = MAX_DISPLAY_NUMBER;
		}
	    
	    //検索条件に該当するセッションを取得
	    Collection sessionList = 
	        CRunSessionUtil.getLocalHome().selectHistoryFilter(
	                startFromDate, 
	                startToDate, 
	                endFromDate, 
	                endToDate, 
	                type, 
	                status, 
	                histories);
	    
	    if(sessionList != null){
	        
			//履歴数を取得
			total = sessionList.size();
			
	        Iterator itr = sessionList.iterator();
			while(itr.hasNext()){
			    //セッションを取得
			    CRunSessionLocal session = (CRunSessionLocal)itr.next();
			    CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                } catch (FinderException e) {
                    
                }
                
			    //履歴一覧の１行を作成
			    ArrayList info = new ArrayList();
			    info.add(session.getStatus());
			    info.add(session.getSession_id());
			    info.add(session.getStart_date());
			    info.add(session.getEnd_date());
			    
			    String name = SelectMaster.typeIdToString(session.getType_id(), locale);
			    if(name != null){
			        info.add(name);
			    }
			    else{
			        info.add("");
			    }
			    
			    if(cmd != null){
			        info.add(Messages.getString(cmd.getName_id(), locale));
			    }
			    else{
			        info.add("");
			    }
			    info.add(session.getFacility_id());
			    info.add(session.getScope_text());
			    info.add(session.getNode_cnt());
			    info.add(session.getEnd_nomal_cnt());
			    info.add(session.getEnd_warning_cnt());
			    info.add(session.getEnd_abnomal_cnt());
			    info.add(session.getWait_cnt());
			    info.add(session.getRunning_cnt());
			    history.add(info);
			    
				//取得した履歴を最大表示件数まで格納したら終了
				if(history.size() >= histories)
					break;
			}
	    }
	    list.setTotal(total);
	    list.setList(history);
	    
	    return list;
	}
	
	/**
	 * 詳細一覧取得
	 * 
	 * @param sessionId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
	    ArrayList list = new ArrayList();
	    
	    //セッションディテールをセッションIDで検索し取得
	    Collection detailList = CRunSessionDetailUtil.getLocalHome().findBySessionId(sessionId);
	    if(detailList != null){
	        Iterator itr = detailList.iterator();
			while(itr.hasNext()){
			    //セッションディテールを取得
			    CRunSessionDetailLocal detail = (CRunSessionDetailLocal)itr.next();
			    
			    //履歴一覧の１行を作成
			    ArrayList info = new ArrayList();
			    info.add(detail.getStatus());
			    info.add(detail.getEnd_status());
			    info.add(detail.getEnd_value());
			    info.add(detail.getFacility_id());
			    info.add(detail.getFacility_name());
			    info.add(detail.getStart_date());
			    info.add(detail.getEnd_date());
			    StringBuffer message = new StringBuffer();
			    if(detail.getMessage() != null){ 
			        message.append(detail.getMessage());
			    }
			    if(detail.getError_message() != null){ 
			        message.append(detail.getError_message());
			    }
			    
			    info.add(message.toString());
			    list.add(info);
			}
	    }
	    return list;
	}
}
