/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.mdb;

import javax.jms.ObjectMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerLocal;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerUtil;
import com.clustercontrol.jobmanagement.message.RunResultInfo;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>CollectiveRunStatusBean</b></em>'. <!-- end-user-doc --> *
 *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CollectiveRunStatusBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/CollectiveRun/status"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=JobController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @jboss.container-configuration 
 *     name="Singleton Message Driven Bean" 
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/CollectiveRun/status"
 * @jboss.destination-jndi-name name="queue/clustercontrol/CollectiveRun/status"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class CollectiveRunStatusBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
    protected static Log m_log = LogFactory.getLog( CollectiveRunStatusBean.class );
    
    /** 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * The context for the message-driven bean, set by the EJB container. 
     * @generated
     */
    private javax.ejb.MessageDrivenContext messageContext = null;

    /** 
     * Required method for container to set context.
     * @generated 
     */
    public void setMessageDrivenContext(
            javax.ejb.MessageDrivenContext messageContext)
            throws javax.ejb.EJBException {
        this.messageContext = messageContext;
    }

    /** 
     * Required creation method for message-driven beans. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition -->
     * @ejb.create-method 
     * <!-- end-xdoclet-definition -->
     * @generated
     */
    public void ejbCreate() {
        //no specific action required for message-driven beans 
    }

    /** 
     * Required removal method for message-driven beans. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void ejbRemove() {
        messageContext = null;
    }

    /** 
     * This method implements the business logic for the EJB. 
     * 
     * <p>Make sure that the business logic accounts for asynchronous message processing. 
     * For example, it cannot be assumed that the EJB receives messages in the order they were 
     * sent by the client. Instance pooling within the container means that messages are not 
     * received or processed in a sequential order, although individual onMessage() calls to 
     * a given message-driven bean instance are serialized. 
     * 
     * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
     * of type javax.jms.Message. The throws clause (if used) must not include an application 
     * exception. Must not be declared as final or static. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void onMessage(javax.jms.Message message) {
        m_log.debug("onMessage()");
        try {
            if(message instanceof ObjectMessage){
                ObjectMessage objectMessage = (ObjectMessage)message;
                if(objectMessage.getObject() instanceof RunResultInfo){

                    RunResultInfo info = (RunResultInfo)objectMessage.getObject();

                    m_log.debug("onMessage() receive: SessionId = " + info.getSessionId() + ", FacilityId = " + info.getFacilityId() + ", status = " + info.getStatus() + ", CommandType = " + info.getCommandType());

    	            CollectiveRunControllerLocal collectiveRun = 
    	                CollectiveRunControllerUtil.getLocalHome().create();
    	            
                    try {
                        collectiveRun.endNode(info);
                    } catch (Exception e) {
                    }
                }
	        }
        } catch (Exception e) {
        }
    }
}
