/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;
import com.clustercontrol.util.Messages;

/**
 * 真偽監視判定 実行ジョブ情報コンポジットクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TruthRunJobComposite extends Composite {
	
	public static final int WIDTH_PRIORITY = 3;
	public static final int WIDTH_JOB_RUN	 = 1;
	public static final int WIDTH_JOB_ID	 = 4;
	public static final int WIDTH_REF_BTN = 2;
	public static final int WIDTH_INHIBITION_FLG = 3;
	public static final int WIDTH_FAILURE_PRIORITY = 2;
	
	/** 判定項目１ */
	private String m_itemTrue = null;
	/** 判定項目２ */
	private String m_itemFalse = null;
	
	/** 実行（True） */ 
	private Button m_checkJobRunTrue = null;
	/** ジョブID（True） */
	private Text m_textJobIdTrue = null;
	/** 参照ボタン（True） */
	private Button m_buttonReferTrue = null;
	/** 通知抑制と連動（True） */ 
	private Button m_checkInhibitionFlgTrue = null;
	/** 呼び出し失敗時重要度（True） */ 
	private Combo m_comboFailurePriorityTrue = null;
	
	/** 実行（False） */
	private Button m_checkJobRunFalse = null;
	/** ジョブID（False） */
	private Text m_textJobIdFalse = null;
	/** 参照ボタン（False） */
	private Button m_buttonReferFalse = null;
	/** 通知抑制と連動（False） */
	private Button m_checkInhibitionFlgFalse = null;
	/** 呼び出し失敗時重要度（False） */
	private Combo m_comboFailurePriorityFalse = null;
	
//	/** 実行（値取得の失敗時） */ 
//	private Button m_checkJobRunFailure = null;
//	/** ジョブID（値取得の失敗時） */
//	private Text m_textJobIdFailure = null;
//	/** 参照ボタン（値取得の失敗時） */
//	private Button m_buttonReferFailure = null;
//	/** 通知抑制と連動（値取得の失敗時） */
//	private Button m_checkInhibitionFlgFailure = null;
//	/** 呼び出し失敗時重要度（値取得の失敗時） */ 
//	private Combo m_comboFailurePriorityFailure = null;
	
	
	/**
	 * インスタンスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 */
	public TruthRunJobComposite(Composite parent, int style, String itemTrue, String itemFalse) {
		super(parent, style);
		
		m_itemTrue = itemTrue;
		m_itemFalse = itemFalse;
		
		this.initialize();
	}
	
	/**
	 * コンポジットを生成・構築します。
	 */
	private void initialize() {
		
		// 変数として利用されるラベル
		Label label = null;
		// 変数として利用されるグリッドデータ
		GridData gridData = null;
		
		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 15;	
		this.setLayout(layout);
		
		// 値
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_PRIORITY;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("value"));
		
		// 実行
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_JOB_RUN;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("run"));
		
		// ジョブID
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_JOB_ID + WIDTH_REF_BTN;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("job.id"));
		
		// 通知抑制と連動
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_INHIBITION_FLG;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("couple.with.notify.inhibition"));
		
		// 呼出失敗時
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_FAILURE_PRIORITY;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("failure.call.value"));
		
		
		/*
         * 値がTrueの場合
         */
		label = this.getLabelPriority(this, Messages.getString(m_itemTrue), WIDTH_PRIORITY);
		this.m_checkJobRunTrue = this.getCheckBox(this, WIDTH_JOB_RUN);
		this.m_textJobIdTrue = this.getTextJobId(this, WIDTH_JOB_ID);
		this.m_buttonReferTrue = this.getButtonRefer(this, WIDTH_REF_BTN);
		this.m_checkInhibitionFlgTrue = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
		this.m_comboFailurePriorityTrue = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
		
		this.m_checkJobRunTrue.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				setEnabled(m_checkJobRunTrue.getSelection(), m_textJobIdTrue, m_buttonReferTrue, m_checkInhibitionFlgTrue, m_comboFailurePriorityTrue);
			}
		});
		m_buttonReferTrue.addSelectionListener(new JobIdSelectionListener(m_textJobIdTrue));
		
		/*
         * 値がFalseの場合
         */
		label = this.getLabelPriority(this, Messages.getString(m_itemFalse), WIDTH_PRIORITY);
		this.m_checkJobRunFalse = this.getCheckBox(this, WIDTH_JOB_RUN);
		this.m_textJobIdFalse = this.getTextJobId(this, WIDTH_JOB_ID);
		this.m_buttonReferFalse = this.getButtonRefer(this, WIDTH_REF_BTN);
		this.m_checkInhibitionFlgFalse = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
		this.m_comboFailurePriorityFalse = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
		
		this.m_checkJobRunFalse.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				setEnabled(m_checkJobRunFalse.getSelection(), m_textJobIdFalse, m_buttonReferFalse, m_checkInhibitionFlgFalse, m_comboFailurePriorityFalse);
			}
		});
		m_buttonReferFalse.addSelectionListener(new JobIdSelectionListener(m_textJobIdFalse));
		
//		// 値取得の失敗時
//		label = this.getLabelPriority(this, Messages.getString("failure.select.value"), WIDTH_PRIORITY);
//		this.m_checkJobRunFailure = this.getCheckBox(this, WIDTH_JOB_RUN);
//		this.m_textJobIdFailure = this.getTextJobId(this, WIDTH_JOB_ID);
//		this.m_buttonReferFailure = this.getButtonRefer(this, WIDTH_REF_BTN);
//		this.m_checkInhibitionFlgFailure = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
//		this.m_comboFailurePriorityFailure = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
//		
//		this.m_checkJobRunFailure.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				setEnabled(m_checkJobRunFailure.getSelection(), m_textJobIdFailure, m_buttonReferFailure, m_checkInhibitionFlgFailure, m_comboFailurePriorityFailure);
//			}
//		});
//		m_buttonReferFailure.addSelectionListener(new JobIdSelectionListener(m_textJobIdFailure));
	}
	
	/**
	 * 各項目に入力値を設定します。
	 * 
	 * @param info 設定値として用いる監視情報
	 */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
			ArrayList list = info.getJudgementInfo();
			if(list != null){
				for(int index=0; index<list.size(); index++){
					MonitorTruthValueInfo truthValueInfo = (MonitorTruthValueInfo)list.get(index);
					if(truthValueInfo != null){
						if(TruthConstant.TYPE_TRUE ==  truthValueInfo.getTruthValue()){
							this.m_checkJobRunTrue.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobRun()));
							if(truthValueInfo.getJobId() != null){
								this.m_textJobIdTrue.setText(truthValueInfo.getJobId());
							}
							this.m_checkInhibitionFlgTrue.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobInhibitionFlg()));
							this.m_comboFailurePriorityTrue.setText(PriorityConstant.typeToString(truthValueInfo.getJobFailurePriority()));
						}
						else if(TruthConstant.TYPE_FALSE ==  truthValueInfo.getTruthValue()){
							this.m_checkJobRunFalse.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobRun()));
							if(truthValueInfo.getJobId() != null){
								this.m_textJobIdFalse.setText(truthValueInfo.getJobId());
							}
							this.m_checkInhibitionFlgFalse.setSelection(YesNoConstant.typeToBoolean(truthValueInfo.getJobInhibitionFlg()));
							this.m_comboFailurePriorityFalse.setText(PriorityConstant.typeToString(truthValueInfo.getJobFailurePriority()));
						}
					}
				}
			}
			
//			this.m_checkJobRunFailure.setSelection(YesNoConstant.typeToBoolean(info.getFailureJobRun()));
//			if(info.getFailureJobId() != null){
//				this.m_textJobIdFailure.setText(info.getFailureJobId());
//			}
//			this.m_checkInhibitionFlgFailure.setSelection(YesNoConstant.typeToBoolean(info.getFailureJobInhibitionFlg()));
//			this.m_comboFailurePriorityFailure.setText(PriorityConstant.typeToString(info.getFailureJobFailurePriority()));
		}
	}
	
	/**
	 * 入力値を用いて監視情報を生成します。
	 * 
	 * @return 検証結果
	 */
	public ValidateResult createInputData(MonitorInfo info) {
		
		ValidateResult validateResult = null;
		
		// 値：OK
		validateResult = setMonitorTruthValueInfo(info, this.m_checkJobRunTrue, this.m_textJobIdTrue, this.m_checkInhibitionFlgTrue, this.m_comboFailurePriorityTrue, TruthConstant.TYPE_TRUE);
		if(validateResult != null){
			return validateResult;
		}
		
		// 値：NG
		validateResult = setMonitorTruthValueInfo(info, this.m_checkJobRunFalse, this.m_textJobIdFalse, this.m_checkInhibitionFlgFalse, this.m_comboFailurePriorityFalse, TruthConstant.TYPE_FALSE);
		if(validateResult != null){
			return validateResult;
		}
		
//		// 値取得の失敗時
//		info.setFailureJobRun(Integer.valueOf(YesNoConstant.booleanToType(this.m_checkJobRunFailure.getSelection())));
//		if (this.m_textJobIdFailure.getText() != null && !"".equals(this.m_textJobIdFailure.getText().trim())) {
//			info.setFailureJobId(this.m_textJobIdFailure.getText());	
//		}
//		else{
//			if(info.getJobRun() == YesNoConstant.TYPE_YES){
//				if(this.m_checkJobRunFailure.getSelection()){
//					String[] args = { "(" + Messages.getString("failure.select.value") + ")" };
//					return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.25", args));
//				}
//			}
//		}
//		info.setFailureJobInhibitionFlg(Integer.valueOf(YesNoConstant.booleanToType(this.m_checkInhibitionFlgFailure.getSelection())));
//		info.setFailureJobFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriorityFailure.getText()));
		
		return null;
	}
	
	/**
	 * 入力値を用いてジョブ実行、ジョブID、通知抑制と連動 及び 呼出失敗時を設定します。
	 * 
	 * @param info 監視情報
	 * @param checkJobRun ジョブ実行チェックボックス
	 * @param textJobId ジョブIDテキストボックス
	 * @param buttonRefer 参照ボタン
	 * @param checkInhibitionFlg 通知抑制との連動
	 * @param comboFailurePriority	呼出失敗時
	 * @param truthValue 真偽値
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult setMonitorTruthValueInfo(MonitorInfo info, Button checkRunJob, Text textJobId, Button checkInhibitionFlg, Combo comboFailurePriority, int truthValue) {
		
		Integer jobRun = Integer.valueOf(YesNoConstant.booleanToType(checkRunJob.getSelection()));
		String jobId = textJobId.getText();
		Integer jobInhibitionFlg = Integer.valueOf(YesNoConstant.booleanToType(checkInhibitionFlg.getSelection()));
		Integer jobFailurePriority = PriorityConstant.stringToType(comboFailurePriority.getText());
		
		boolean find = false;
		MonitorTruthValueInfo truthValueInfo = null;
		
		ArrayList list = info.getJudgementInfo();
		if(list != null){
			for(int index=0; index<list.size(); index++){
				truthValueInfo = (MonitorTruthValueInfo)list.get(index);
				if(truthValueInfo != null){
					if(truthValue == truthValueInfo.getTruthValue()){
						find = true;
						break;
					}
				}
			}
		}
		
		if(!find){
			truthValueInfo = new MonitorTruthValueInfo();
			truthValueInfo.setMonitorId(info.getMonitorId());
			truthValueInfo.setMonitorTypeId(info.getMonitorTypeId());
			truthValueInfo.setTruthValue(truthValue);
		}
		
		// ジョブ実行
		truthValueInfo.setJobRun(jobRun);
		
		// ジョブID
		if (jobId != null && !"".equals(jobId.trim())) {
			truthValueInfo.setJobId(jobId);	
		}
		else{
			if(info.getJobRun() == YesNoConstant.TYPE_YES){
				if(checkRunJob.getSelection()){
					String tmp = null;
					if(truthValue == TruthConstant.TYPE_TRUE){
						tmp = m_itemTrue;
					}
					else if(truthValue == TruthConstant.TYPE_FALSE){
						tmp = m_itemFalse;
					}
					String[] args = { "(" + tmp + ")" };
					return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.25", args));
				}
			}
		}
		
		// 通知抑制と連動
		truthValueInfo.setJobInhibitionFlg(jobInhibitionFlg);
		// 呼出失敗時
		truthValueInfo.setJobFailurePriority(jobFailurePriority);
		
		if(!find){
			list.add(truthValueInfo);
		}
		info.setJudgementInfo(list);
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		setEnabled(enabled, m_checkJobRunTrue, m_textJobIdTrue, m_buttonReferTrue, m_checkInhibitionFlgTrue, m_comboFailurePriorityTrue);
		setEnabled(enabled, m_checkJobRunFalse, m_textJobIdFalse, m_buttonReferFalse, m_checkInhibitionFlgFalse, m_comboFailurePriorityFalse);
//		setEnabled(enabled, m_checkJobRunFailure, m_textJobIdFailure, m_buttonReferFailure, m_checkInhibitionFlgFailure, m_comboFailurePriorityFailure);
	}
	
	/**
	 * コンポジットのEnabledを設定します
	 * 
	 * @param enabled
	 * @param checkJobRun ジョブ実行チェックボックス
	 * @param textJobId ジョブIDテキストボックス
	 * @param buttonRefer 参照ボタン
	 * @param checkInhibitionFlg 通知抑制との連動
	 * @param comboFailurePriority	呼出失敗時
	 */
	public void setEnabled(boolean enabled,
			Button checkJobRun,
			Text textJobId,
			Button buttonRefer,
			Button checkInhibitionFlg,
			Combo comboFailurePriority
	) {
		
		checkJobRun.setEnabled(enabled);
		
		if(enabled){
			setEnabled(checkJobRun.getSelection(), textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
		}
		else{
			setEnabled(enabled, textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
		}
	}
	
	/**
	 * コンポジットのEnabledを設定します
	 * 
	 * @param enabled
	 * @param textJobId ジョブIDテキストボックス
	 * @param buttonRefer 参照ボタン
	 * @param checkInhibitionFlg 通知抑制との連動
	 * @param comboFailurePriority	呼出失敗時
	 */
	public void setEnabled(boolean enabled,
			Text textJobId,
			Button buttonRefer,
			Button checkInhibitionFlg,
			Combo comboFailurePriority
	) {
		
		textJobId.setEnabled(enabled);
		buttonRefer.setEnabled(enabled);
		checkInhibitionFlg.setEnabled(enabled);
		comboFailurePriority.setEnabled(enabled);
	}
	
	/**
	 * 重要度テキストを返します。
	 * 
	 * @param parent 親のインスタンス
	 * @param text ラベルテキスト
	 * @param horizontalSpan カラム数
	 * @return
	 */
	protected Label getLabelPriority(Composite parent,
			String text,
			int horizontalSpan
	) {
		
		// ラベル（重要度）
		Label label = new Label(parent, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(text + " : ");
		
		return label;
	}
	
	/**
	 * 重要度コンボボックスを返します。
	 * 
	 * @param parent 親のインスタンス
	 * @param horizontalSpan カラム数
	 * @return
	 */
	protected Combo getComboPriority(Composite parent, int horizontalSpan) {
		
		Combo combo = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		combo.setLayoutData(gridData);
		combo.add(PriorityConstant.STRING_CRITICAL);
		combo.add(PriorityConstant.STRING_WARNING);
		combo.add(PriorityConstant.STRING_INFO);
		combo.add(PriorityConstant.STRING_UNKNOWN);
		combo.setText(PriorityConstant.STRING_UNKNOWN);
		
		return combo;
	}
	
	/**
	 * チェックボックスを返します。
	 * 
	 * @param parent 親のインスタンス
	 * @param horizontalSpan カラム数
	 * @return
	 */
	protected Button getCheckBox(Composite parent, int horizontalSpan) {
		
		// チェックボックス
		Button button = new Button(parent, SWT.CHECK);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.CENTER;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		
		return button;
	}
	
	/**
	 * ジョブIDテキストボックスを返します。
	 * 
	 * @param parent 親のインスタンス
	 * @param horizontalSpan カラム数
	 * @return
	 */
	protected Text getTextJobId(Composite parent, int horizontalSpan) {
		
		Text text = new Text(this, SWT.BORDER | SWT.LEFT | SWT.READ_ONLY);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		text.setLayoutData(gridData);
		
		return text;
	}
	
	/**
	 * 参照ボタンを返します。
	 * 
	 * @param parent 親のインスタンス
	 * @param horizontalSpan カラム数
	 * @return
	 */
	protected Button getButtonRefer(Composite parent, int horizontalSpan) {
		
		Button button = new Button(this, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		button.setText(Messages.getString("refer"));
		
		return button;
	}
	
	
	/**
	 * 無効な入力値の情報を設定します
	 *  
	 */
	protected ValidateResult setValidateResult(String id, String message) {
		
		ValidateResult validateResult = new ValidateResult();
		validateResult.setValid(false);
		validateResult.setID(id);
		validateResult.setMessage(message);
		
		return validateResult;
	}
}