/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.util.Messages;

/**
 * 監視条件実行間隔コンポジットクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NumericMessageComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    /** メッセージID：通知 */
    private Text m_textInfoId = null;
    
    /** メッセージ：通知 */
    private Text m_textInfoMessage = null;
    
    /** メッセージID：警告 */
    private Text m_textWarnId = null;

    /** メッセージ：警告 */
    private Text m_textWarnMessage = null;
    
    /** メッセージID：警告 */
    private Text m_textCriticalId = null;

    /** メッセージ：警告 */
    private Text m_textCriticalMessage = null;

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     */
    public NumericMessageComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }
    
    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
    	
    	// 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;	
        this.setLayout(layout);
        
        // 重要度
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("priority"));
        
        // メッセージID
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE * 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("message.id"));

        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE * 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("message"));
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // 重要度：通知
        label = this.getLabelPriority(this, Messages.getString("info"),PriorityColorConstant.COLOR_INFO);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージID
        this.m_textInfoId = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE * 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoId.setLayoutData(gridData);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージ
        this.m_textInfoMessage = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textInfoMessage.setLayoutData(gridData);
                
        // 重要度：警告
        label = this.getLabelPriority(this, Messages.getString("warning"),PriorityColorConstant.COLOR_WARNING);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージID
        this.m_textWarnId = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE * 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnId.setLayoutData(gridData);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージ
        this.m_textWarnMessage = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textWarnMessage.setLayoutData(gridData);

        // 重要度：異常
        label = this.getLabelPriority(this, Messages.getString("critical"),PriorityColorConstant.COLOR_CRITICAL);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージID
        this.m_textCriticalId = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE * 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textCriticalId.setLayoutData(gridData);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // メッセージ
        this.m_textCriticalMessage = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textCriticalMessage.setLayoutData(gridData);
	}

    /**
     * 各項目に入力値を設定します。
     * 
     * @param info 設定値として用いる監視情報
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
	        ArrayList list = info.getJudgementInfo();
	        if(list != null){
	            for(int index=0; index<list.size(); index++){
	            	MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
	            	if(numericValueInfo != null){
	                	if(PriorityConstant.TYPE_INFO ==  numericValueInfo.getPriority()){
	                		this.m_textInfoId.setText(numericValueInfo.getMessageId());
	                		this.m_textInfoMessage.setText(numericValueInfo.getMessage());
	                	}
	                	else if(PriorityConstant.TYPE_WARNING ==  numericValueInfo.getPriority()){
	                		this.m_textWarnId.setText(numericValueInfo.getMessageId());
	                		this.m_textWarnMessage.setText(numericValueInfo.getMessage());
	                	}
	                	else if(PriorityConstant.TYPE_CRITICAL ==  numericValueInfo.getPriority()){
	                		this.m_textCriticalId.setText(numericValueInfo.getMessageId());
	                		this.m_textCriticalMessage.setText(numericValueInfo.getMessage());
	                	}
	            	}
	            }
	        }
		}
	}

	/**
     * 入力値を用いて監視情報を生成します。
     * 
     * @return 検証結果
     */
	public ValidateResult createInputData(MonitorInfo info) {
        String id = null;
        String message = null;
        ValidateResult validateResult = null;
        
        // 重要度：通知
        id = this.m_textInfoId.getText();
        message = this.m_textInfoMessage.getText();

        validateResult = setMonitorNumericValueInfo(info, id, message, PriorityConstant.TYPE_INFO);
        if(validateResult != null){
        	return validateResult;
        }
        
        // 重要度：警告
        id = this.m_textWarnId.getText();
        message = this.m_textWarnMessage.getText();

        validateResult = setMonitorNumericValueInfo(info, id, message, PriorityConstant.TYPE_WARNING);
        if(validateResult != null){
        	return validateResult;
        }
        
        // 重要度：異常
        id = this.m_textCriticalId.getText();
        message = this.m_textCriticalMessage.getText();

        validateResult = setMonitorNumericValueInfo(info, id, message, PriorityConstant.TYPE_CRITICAL);
        if(validateResult != null){
        	return validateResult;
        }
        
		return null;
	}
	
	/**
     * 入力値を用いてメッセージIDとメッセージを設定します。
     * 
	 * @param info
	 * @param id
	 * @param message
	 * @param priority
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult setMonitorNumericValueInfo(MonitorInfo info, String id, String message, int priority) {
        boolean find = false;
		MonitorNumericValueInfo numericValueInfo = null;
        
		ArrayList list = info.getJudgementInfo();
        if(list != null){
            for(int index=0; index<list.size(); index++){
            	numericValueInfo = (MonitorNumericValueInfo)list.get(index);
            	if(numericValueInfo != null){
                	if(priority == numericValueInfo.getPriority()){
                		find = true;
	                    break;
                	}
            	}
            }
        }
        
        if(!find){
            numericValueInfo = new MonitorNumericValueInfo();
            numericValueInfo.setMonitorId(info.getMonitorId());
            numericValueInfo.setMonitorTypeId(info.getMonitorTypeId());
            numericValueInfo.setPriority(priority);
            numericValueInfo.setMessageId(id);
            numericValueInfo.setMessage(message);
            numericValueInfo.setThresholdLowerLimit(0f);
            numericValueInfo.setThresholdUpperLimit(0f);
            list.add(numericValueInfo);
        }
        
        if (id != null && !"".equals(id.trim())) {
        	numericValueInfo.setMessageId(id);	
        }
        else{
    		if(PriorityConstant.TYPE_INFO ==  priority){
    			return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.13"));
    		}
    		else if(PriorityConstant.TYPE_WARNING ==  priority){
    			return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.15"));
    		}
    		else if(PriorityConstant.TYPE_CRITICAL ==  priority){
    			return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.17"));
    		}
        }
        if (message != null && !"".equals(message.trim())) {
        	numericValueInfo.setMessage(message);	
        }
        else{
        	if(PriorityConstant.TYPE_INFO ==  priority){
        		return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.14"));
        	}
        	else if(PriorityConstant.TYPE_WARNING ==  priority){
        		return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.16"));
        	}
        	else if(PriorityConstant.TYPE_CRITICAL ==  priority){
        		return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.18"));
        	}
        }
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		this.m_textInfoId.setEnabled(enabled);
		this.m_textInfoMessage.setEnabled(enabled);
		this.m_textWarnId.setEnabled(enabled);
		this.m_textWarnMessage.setEnabled(enabled);
		this.m_textCriticalId.setEnabled(enabled);
		this.m_textCriticalMessage.setEnabled(enabled);
	}
	
	/**
     * 重要度テキストを返します。
     * 
     * @param parent 親のインスタンス
     */
    protected Label getLabelPriority(Composite parent,
    		String text,
    		Color background
    		) {
    	
    	// ラベル（重要度）
    	Label label = new Label(parent, SWT.NONE);
    	GridData gridData = new GridData();
    	gridData.horizontalSpan = 2;
    	gridData.horizontalAlignment = GridData.FILL;
    	gridData.grabExcessHorizontalSpace = true;
    	label.setLayoutData(gridData);
    	label.setText(text + " : ");
    	label.setBackground(background);
        
        return label;
    }
    
	/**
     * 無効な入力値の情報を設定します
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
}