/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * 監視条件（タイムアウト含む）コンポジットクラスです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorRuleTimeoutComposite extends MonitorRuleComposite {
	
	// ----- instance フィールド ----- //
	
	/** タイムアウト */
	protected Text m_textTimeout = null;
	
	/** タイムアウトラベル */
	private String m_timeoutText = Messages.getString("time.out.sec");
	
	
	// ----- コンストラクタ ----- //
	
	/**
	 * インスタンスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 */
	public MonitorRuleTimeoutComposite(Composite parent, int style) {
		super(parent, style);
		
		this.initialize();
	}
	
	/**
	 * インスタンスを返します。
	 * 
	 * @param parent 親のコンポジット
	 * @param style スタイル
	 */
	public MonitorRuleTimeoutComposite(Composite parent, int style, String label) {
		super(parent, style);
		
		m_timeoutText = label;
		
		this.initialize();
	}
	
	/**
	 * コンポジットを生成・構築します。
	 */
	private void initialize() {
		
		// 変数として利用されるラベル
		Label label = null;
		// 変数として利用されるグリッドデータ
		GridData gridData = null;
		
		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 15;	
		this.setLayout(layout);
		
		/*
		 * タイムアウト
		 */
		/*
		 * タイムアウト(ミリ秒)
		 */
		// ラベル
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(m_timeoutText + " : ");
		// コンボボックス
		this.m_textTimeout = new Text(this, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_VALUE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_textTimeout.addVerifyListener(new PositiveNumberVerifyListener());
		this.m_textTimeout.setLayoutData(gridData);
		
		// 空白
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_WHITE_SPACE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
	}
	
	/**
	 * 各項目に入力値を設定します。
	 * 
	 * @param info 設定値として用いる監視情報
	 */
	public void setInputData(MonitorInfo info) {
		
		super.setInputData(info);
		
		if(info != null){
			this.m_textTimeout.setText(Integer.toString(info.getTimeout()));
		}
	}
	
	/**
	 * 入力値を用いて監視情報を生成します。
	 * 
	 * @return 検証結果
	 */
	public ValidateResult createInputData(MonitorInfo info) {
		
		ValidateResult validateResult = super.createInputData(info);
		
		if(validateResult != null){
			return validateResult;
		}
		else{
			if (this.m_textTimeout.getText() != null
					&& !"".equals((this.m_textTimeout.getText()).trim())) {
				
				int timeout = -1;
				try {
					timeout = Integer.valueOf(this.m_textTimeout.getText());
					if(timeout > info.getRunInterval()){
						return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.43"));
					}
					info.setTimeout(timeout);
				} catch (NumberFormatException e) {
					return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.42"));
				}
			}
			else{
				return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.42"));
			}
		}
		return null;
	}
	
	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		super.setEnabled(enabled);
		this.m_textTimeout.setEnabled(enabled);
	}
	
	/**
	 * 無効な入力値の情報を設定します
	 *  
	 */
	protected ValidateResult setValidateResult(String id, String message) {
		
		ValidateResult validateResult = new ValidateResult();
		validateResult.setValid(false);
		validateResult.setID(id);
		validateResult.setMessage(message);
		
		return validateResult;
	}
}