/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.RunIntervalConstant;
import com.clustercontrol.calendar.composite.CalendarIdListComposite;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * 監視条件コンポジットクラスです。
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class MonitorRuleComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 5;
	public static final int WIDTH_WHITE_SPACE = 5;

    // ----- instance フィールド ----- //

    /** 実行間隔 */
	protected Combo m_comboRunInterval = null;
	
	/** カレンダID */
    private CalendarIdListComposite m_calendarId = null;


    // ----- コンストラクタ ----- //

    /**
     * インスタンスを返します。
     * 
     * @param parent 親のコンポジット
     * @param style スタイル
     */
    public MonitorRuleComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }
    
    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
    	
    	// 変数として利用されるラベル
        Label label = null;
        // 変数として利用されるグリッドデータ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;	
        this.setLayout(layout);
        
        /*
         * 実行間隔（分）
         */
        // ラベル
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("run.interval") + " : ");
        // コンボボックス
        this.m_comboRunInterval = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData(gridData);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_01);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_05);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_15);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_30);
        this.m_comboRunInterval.add(RunIntervalConstant.STRING_MIN_60);
        
        // 空白
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_WHITE_SPACE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * カレンダ
         */
		this.m_calendarId = new CalendarIdListComposite(this, SWT.NONE, true);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_calendarId.setLayoutData(gridData);
	}

    /**
     * 各項目に入力値を設定します。
     * 
     * @param info 設定値として用いる監視情報
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
	        this.m_comboRunInterval.setText(RunIntervalConstant.typeToString(info.getRunInterval()));
	        if (info.getCalendarId() != null) {
	            this.m_calendarId.setText(info.getCalendarId());
	        }
		}
	}

	/**
     * 入力値を用いて監視情報を生成します。
     * 
     * @return 検証結果
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
		if(info != null){
	        if (this.m_comboRunInterval.getText() != null
	                && !"".equals((this.m_comboRunInterval.getText()).trim())) {
	        	info.setRunInterval(RunIntervalConstant.stringToType(this.m_comboRunInterval.getText()));
	        } else {
	        	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.11"));
	        }
	        
	        if (this.m_calendarId.getText() != null
	                && !"".equals((this.m_calendarId.getText()).trim())) {
	        	info.setCalendarId(this.m_calendarId.getText());
	        }
		}
		return null;
	}
	
	/* (非 Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_comboRunInterval.setEnabled(enabled);
		this.m_calendarId.setEnabled(enabled);
	}
	
	/**
     * 無効な入力値の情報を設定します
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
}