/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.common.dialog;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.common.composite.JobTreeComposite;
import com.clustercontrol.util.Messages;

/**
 * ジョブツリーからジョブを選択するためのダイアログです。
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobTreeDialog extends CommonDialog {
	
	/** 選択されたアイテム */
	private JobTreeComposite treeComposite = null;
	
	/**
	 * ダイアログのインスタンスを返します。
	 * 
	 * @param parent
	 *            親とするシェル
	 */
	public JobTreeDialog(Shell parent) {
		super(parent);
	}
	
	protected Point getInitialSize() {
		return new Point(400, 400);
	}
	
	protected void customizeDialog(Composite parent) {
		// タイトル
		parent.getShell().setText(Messages.getString("select.job"));
		
		GridLayout layout = new GridLayout(5, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		
		treeComposite = new JobTreeComposite(parent, SWT.NONE);
		
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 5;
		treeComposite.setLayoutData(gridData);
		
		// アイテムをダブルクリックした場合、それを選択したこととする。
		treeComposite.getTreeViewer().addDoubleClickListener(
				new IDoubleClickListener() {
					public void doubleClick(DoubleClickEvent event) {
						okPressed();
					}
				});
	}
	
	public JobTreeItem getSelectItem() {
		return this.treeComposite.getSelectItem();
	}
	
	protected ValidateResult validate() {
		ValidateResult result = null;
		
		JobTreeItem item = this.getSelectItem();
		if (item instanceof JobTreeItem) {
			if (item.getData().getType() == JobConstant.TYPE_COMPOSITE) {
				result = new ValidateResult();
				result.setValid(false);
				result.setID(Messages.getString("message.hinemos.1"));
				result.setMessage(Messages.getString("message.job.1"));
			}
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("message.job.1"));
		}
		
		return result;
	}
	
	protected String getOkButtonText() {
		return Messages.getString("ok");
	}
	
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}
}