/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.common.composite;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.common.action.GetJobTree;
import com.clustercontrol.jobmanagement.common.composite.JobTreeContentProvider;
import com.clustercontrol.jobmanagement.common.composite.JobTreeLabelProvider;

/**
 * ジョブ階層ツリーコンポジット
 *  
 */
public class JobTreeComposite extends Composite {
	private TreeViewer m_viewer = null;
	
	private JobTreeItem m_selectItem = null;
	
	
	public JobTreeComposite(Composite parent, int style) {
		super(parent, style);
		
		initialize();
	}
	
	private void initialize() {
		GridLayout layout = new GridLayout(1, true);
		this.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		
		Tree tree = new Tree(this, SWT.SINGLE | SWT.BORDER);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		tree.setLayoutData(gridData);
		
		m_viewer = new TreeViewer(tree);
		m_viewer.setContentProvider(new JobTreeContentProvider());
		m_viewer.setLabelProvider(new JobTreeLabelProvider());
		
		// 選択アイテム取得イベント定義
		m_viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				StructuredSelection selection = (StructuredSelection) event
				.getSelection();
				
				m_selectItem = (JobTreeItem) selection.getFirstElement();
			}
		});
		
		update();
	}
	
	/**
	 * このコンポジットが利用するツリービューアを返します。
	 * 
	 * @return ツリービューア
	 */
	public TreeViewer getTreeViewer() {
		return m_viewer;
	}
	
	/**
	 * このコンポジットが利用するツリーを返します。
	 * 
	 * @return ツリー
	 */
	public Tree getTree() {
		return m_viewer.getTree();
	}
	
	/**
	 * 更新処理
	 * 
	 * @since 1.0.0
	 */
	public void update() {
		m_selectItem = null;
		
		//ジョブ一覧情報取得
		GetJobTree getJobTree = new GetJobTree();
		JobTreeItem jobTree = getJobTree.getJobTree(true);
		
		m_viewer.setInput(jobTree);
		
		//ジョブユニットのレベルまで展開
		m_viewer.expandToLevel(2);
	}
	
	/**
	 * 現在選択されているツリーアイテムを返します。
	 * 
	 * @return ツリーアイテム
	 */
	public JobTreeItem getSelectItem() {
		return m_selectItem;
	}
	
	/**
	 * 現在選択されているツリーアイテムを設定
	 * 
	 * @param item
	 */
	public void setSelectItem(JobTreeItem item) {
		m_selectItem = item;
	}
}