/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.dialog;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.vafada.swtcalendar.SWTCalendar;
import org.vafada.swtcalendar.SWTCalendarEvent;
import org.vafada.swtcalendar.SWTCalendarListener;

import com.clustercontrol.util.Messages;

/**
 * カレンダーダイアログクラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CalendarDialog extends CommonDialog {
    private SWTCalendar swtcal = null;

    private Date dateBuffer;

    private Date dateBefore;

    private Date date;

    /**
     * コンストラクタ
     * 
     * @param parent
     * @since 1.0.0
     */
    public CalendarDialog(Shell parent) {
        super(parent);
    }

    /**
     * ダイアログ作成
     * 
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     * @since 1.0.0
     */
    protected void customizeDialog(Composite composite) {
        composite.getShell().setText(Messages.getString("calendar"));

        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout(gridLayout);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;

        swtcal = new SWTCalendar(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        swtcal.setLayoutData(gridData);

        //カレンダー日付変更時リスナー
        swtcal.addSWTCalendarListener(new SWTCalendarListener() {
            public void dateChanged(SWTCalendarEvent calendarEvent) {
                dateBuffer = calendarEvent.getCalendar().getTime();
            }
        });

        if (dateBefore != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateBefore);
            swtcal.setCalendar(calendar);
        }
    }

    /**
     * 日付設定
     * 
     * @param date
     * @since 1.0.0
     */
    public void setDate(Date date) {
        dateBefore = date;
    }

    /**
     * 日付取得
     * 
     * @return
     * @since 1.0.0
     */
    public Date getDate() {
        return date;
    }

    /**
     * キャンセルボタンクリック時の処理
     * 
     * @see org.eclipse.jface.dialogs.Dialog#cancelPressed()
     * @since 1.0.0
     */
    protected void cancelPressed() {
        date = dateBefore;

        super.cancelPressed();
    }

    /**
     * OKボタンクリック時の処理
     * 
     * @see org.eclipse.jface.dialogs.Dialog#okPressed()
     * @since 1.0.0
     */
    protected void okPressed() {
        if (dateBuffer != null) {
            date = dateBuffer;
        }
        super.okPressed();
    }
    
    protected ValidateResult validate() {
        ValidateResult result = null;

        Calendar work = Calendar.getInstance();
        work.setTime(date);
        work.getTime();
        
        Calendar startDate = Calendar.getInstance();
        startDate.set(Calendar.YEAR, 1970);
        startDate.set(Calendar.MONTH, 0);
        startDate.set(Calendar.DAY_OF_MONTH, 1);
        startDate.set(Calendar.HOUR_OF_DAY, 0);
        startDate.set(Calendar.MINUTE, 0);
        startDate.set(Calendar.SECOND, 0);
        startDate.set(Calendar.MILLISECOND, 0);
        startDate.getTime();
        
        Calendar endDate = Calendar.getInstance();
        endDate.set(Calendar.YEAR, 2199);
        endDate.set(Calendar.MONTH, 11);
        endDate.set(Calendar.DAY_OF_MONTH, 31);
        endDate.set(Calendar.HOUR_OF_DAY, 23);
        endDate.set(Calendar.MINUTE, 59);
        endDate.set(Calendar.SECOND, 59);
        endDate.set(Calendar.MILLISECOND, 999);
        endDate.getTime();
        
        if(work.after(startDate) && work.before(endDate)){
        	result = null;
        }
        else{
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            
            DateFormat format = DateFormat.getDateInstance();
            String[] args1 = {format.format(startDate.getTime()), format.format(endDate.getTime())};
            result.setMessage(Messages.getString("message.hinemos.5", args1));
        }

        return result;
    }
}