/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;

/**
 * 正数用VerifyListenerクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PositiveNumberVerifyListener implements VerifyListener {
    protected static String numberChar = "0123456789";

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.swt.events.VerifyListener#verifyText(org.eclipse.swt.events.VerifyEvent)
     */
    public void verifyText(VerifyEvent e) {
        //キー入力以外は有効にする
        if (e.keyCode == 0) {
            return;
        }
        //BackspaceやDeleteが押されたときは、有効にする
        if (e.character == SWT.BS || e.character == SWT.DEL) {
            return;
        }
        //数字以外は無効にする
        if (numberChar.indexOf(Character.toString(e.character)) == -1) {
            e.doit = false;
        }
    }
}