/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.SWT;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.PropertyDefine;

/**
 * コンボボックスプロパティ定義
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ComboPropertyDefine extends PropertyDefine implements Serializable {

    private final static int DISP_TEXT = 0;

    private final static int VALUE = 1;

    protected Object m_values[][]; //表示文字列と、値のマップm_values[0]が表示

    /**
     * コンストラクタ
     * 
     * @since 1.0.0
     */
    public ComboPropertyDefine() {
        m_cellEditor = new ComboBoxCellEditor();
        m_cellEditor.setStyle(SWT.READ_ONLY);
    }

    /**
     * コンストラクタ
     * 
     * @since 1.0.0
     */
    public ComboPropertyDefine(Object[][] value) {
        m_values = value;
        m_cellEditor = new ComboBoxCellEditor();
        m_cellEditor.setStyle(SWT.READ_ONLY);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getColumnText(java.lang.Object)
     */
    public String getColumnText(Object value) {
        //値から表示テキスト
        for (int i = 0; i < m_values[PropertyConstant.SELECT_VALUE].length; i++) {
            Object select = null;
            if (m_values[PropertyConstant.SELECT_VALUE][i] instanceof HashMap) {
                HashMap map = (HashMap) m_values[PropertyConstant.SELECT_VALUE][i];
                select = map.get(PropertyConstant.MAP_VALUE);
            } else {
                select = m_values[PropertyConstant.SELECT_VALUE][i];
            }

            if (value.equals(select)) {
                return (String) select;
            }
        }
        return "";
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#getValue(com.clustercontrol.bean.Property)
     */
    public Object getValue(Property element) {
        //Comboに渡すために値からインデックス番号に変換
        Object value = element.getValue();
        for (int i = 0; i < m_values[PropertyConstant.SELECT_VALUE].length; i++) {
            Object select = null;
            if (m_values[PropertyConstant.SELECT_VALUE][i] instanceof HashMap) {
                HashMap map = (HashMap) m_values[PropertyConstant.SELECT_VALUE][i];
                select = map.get(PropertyConstant.MAP_VALUE);
            } else {
                select = m_values[PropertyConstant.SELECT_VALUE][i];
            }

            if (value.equals(select)) {
                return new Integer(i);
            }
        }
        return new Integer(-1);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#modify(com.clustercontrol.bean.Property,
     *      java.lang.Object)
     */
    public void modify(Property element, Object value) {
        //インデックス番号から値に変換
        if (value instanceof Integer) {
            int valueIndex = ((Integer) value).intValue();
            if (valueIndex >= 0) {
                if (m_values[PropertyConstant.SELECT_VALUE][valueIndex] instanceof HashMap) {
                    HashMap map = (HashMap) m_values[PropertyConstant.SELECT_VALUE][valueIndex];
                    element.setValue(map.get(PropertyConstant.MAP_VALUE));

                    ArrayList propertyList = (ArrayList) map
                            .get(PropertyConstant.MAP_PROPERTY);
                    if (propertyList instanceof ArrayList) {
                        element.removeChildren();
                        for (int i = 0; i < propertyList.size(); i++) {
                            element.addChildren((Property) propertyList.get(i));
                        }
                    }
                } else {
                    element.removeChildren();
                    Object select = m_values[PropertyConstant.SELECT_VALUE][valueIndex];
                    element.setValue(select);
                }
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.bean.PropertyDefine#initEditer()
     */
    public void initEditer() {
        //createでparentを指定した後に、リストの文字列を渡さないといけないので。
        String[] value = new String[m_values[PropertyConstant.SELECT_DISP_TEXT].length];
        for (int i = 0; i < m_values[PropertyConstant.SELECT_DISP_TEXT].length; i++) {
            value[i] = (String) m_values[PropertyConstant.SELECT_DISP_TEXT][i];
        }
        ((ComboBoxCellEditor) m_cellEditor).setItems(value);
    }

    /**
     * @return Returns the m_values.
     */
    public Object[][] getValues() {
        return m_values;
    }

    /**
     * @param m_values
     *            The m_values to set.
     */
    public void setValues(Object[][] values) {
        this.m_values = values;
    }
}