/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view.action;

import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.action.ModifyCalendarProperty;
import com.clustercontrol.calendar.bean.CalendarListTableDefine;
import com.clustercontrol.calendar.dialog.CalendarDialog;
import com.clustercontrol.calendar.view.CalendarListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダの作成・変更ダイアログによる、カレンダ変更を行うアクションクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CalendarModifyAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.calendar.view.action.CalendarModifyAction";
	
    private IViewPart viewPart;

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // カレンダ一覧より、選択されているカレンダIDを取得

        CalendarListView view = (CalendarListView) this.viewPart
                .getAdapter(CalendarListView.class);

        StructuredSelection selection = (StructuredSelection) view
                .getListComposite().getTableViewer().getSelection();

        List list = (List) selection.getFirstElement();
        String id = null;
        if (list != null) {
            id = (String) list.get(CalendarListTableDefine.CALENDAR_ID);
        }

        if (id != null) {
            // ダイアログを生成
            CalendarDialog dialog = new CalendarDialog(this.viewPart
                    .getSite().getShell(), id, PropertyConstant.MODE_MODIFY);

            // ダイアログにて変更が選択された場合、入力内容をもって更新を行う。
            if (dialog.open() == IDialogConstants.OK_ID) {
                Property property = dialog.getInputData();

                PropertyUtil.deletePropertyDefine(property);
                if (new ModifyCalendarProperty().edit(property)) {
                    // 成功報告ダイアログを生成
                    MessageBox box = new MessageBox(this.viewPart.getSite()
                            .getShell(), SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.calendar.3"));
                    box.open();
                } else {
                    // 失敗報告ダイアログを生成
                    MessageBox box = new MessageBox(this.viewPart.getSite()
                            .getShell(), SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.calendar.4"));
                    box.open();
                }

                view.update();
            }
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}