/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.calendar.composite.AddInfoListComposite;
import com.clustercontrol.calendar.view.action.AddInfoAddAction;
import com.clustercontrol.calendar.view.action.AddInfoDeleteAction;
import com.clustercontrol.calendar.view.action.AddInfoModifyAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * カレンダ追加情報一覧ビュークラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class AddInfoListView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.calendar.view.AddInfoListView";

    private AddInfoListComposite m_addList = null;

    /**
     * コンストラクタ
     */
    public AddInfoListView() {
        super();
    }

    /**
     * ViewPartへのコントロール作成処理
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_addList = new AddInfoListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_addList.setLayoutData(gridData);

        //ポップアップメニュー作成
        createContextMenu();

        //ビューを更新
        this.update(null);
    }

    /**
     * ポップアップメニュー作成
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //メニュー項目設定
                fillContextMenu(manager);
            }
        });

        Menu menu = menuManager.createContextMenu(m_addList.getTable());
        m_addList.getTable().setMenu(menu);
    }

    /**
     * メニュー項目追加
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ビューのアクションのインスタンスを取得
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
    	ActionContributionItem add = 
    		(ActionContributionItem) toolbar.find(AddInfoAddAction.ID);
    	ActionContributionItem modify = 
    		(ActionContributionItem) toolbar.find(AddInfoModifyAction.ID);
    	ActionContributionItem delete = 
    		(ActionContributionItem) toolbar.find(AddInfoDeleteAction.ID);
    	
    	//ポップアップメニューにアクションを追加
    	manager.add(add.getAction());
    	manager.add(modify.getAction());
    	manager.add(delete.getAction());
    }

    /**
     * カレンダ追加情報一覧ビュー更新
     */
    public void update(String calendarId) {
    	m_addList.update(calendarId);
    }

    /**
     * コンポジット取得処理
     * 
     * @return
     */
    public AddInfoListComposite getComposite() {
        return m_addList;
    }
}