/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.dialog;

import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.calendar.action.AddWeekdayInfoProperty;
import com.clustercontrol.calendar.action.GetWeekdayInfoProperty;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * カレンダ曜日別情報の作成・変更ダイアログクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class WeekdayInfoDialog extends CommonDialog {
    /** ID */
    private String id = "";
    /** 曜日 */
    private Integer weekday;
    /** 時間帯(From) */
    private Date from;
    /** 時間帯(To) */
    private Date to;

    /** 変更用ダイアログ判別フラグ */
    private int mode;

    /** カレンダプロパティシート */
    private PropertySheet propertySheet = null;
    /**
     * 指定した形式のダイアログのインスタンスを返します。
     * 
     * @param parent
     *            親のシェルオブジェクト
     * @param id
     *            カレンダID
     * @param mode
     *            表示モード
     */
    public WeekdayInfoDialog(Shell parent, String id, Integer weekday, Date from, Date to, int mode) {
        super(parent);

        this.id = id;
        this.weekday = weekday;
        this.from = from;
        this.to = to;
        this.mode = mode;
    }
    
    /**
     * ダイアログの初期サイズを返します。
     * 
     * @return 初期サイズ
     */
    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent
     *            親のインスタンス
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages
                .getString("dialog.calendar.weekday.create.modify"));

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * 属性プロパティシート
         */

        // ラベル
        Label calendarId = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        calendarId.setLayoutData(gridData);
        calendarId.setText(Messages.getString("calendar.id") + " : " + id);
        
        Label rtn = new Label(parent, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        rtn.setLayoutData(gridData);
        rtn.setText("");
        
        // ラベル
        Label attribute = new Label(parent, SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        attribute.setLayoutData(gridData);
        attribute.setText(Messages.getString("attribute") + " : ");

        // プロパティシート
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // プロパティ取得及び設定
        Property property = null;
        if (this.mode == PropertyConstant.MODE_MODIFY) {
            property = new GetWeekdayInfoProperty().getProperty(
            		this.id, 
            		this.weekday, 
            		this.from, 
            		this.to, 
                    PropertyConstant.MODE_MODIFY);
        } 
        else if (this.mode == PropertyConstant.MODE_ADD) {
            property = new GetWeekdayInfoProperty().getProperty(
            		this.id, 
            		this.weekday, 
            		this.from, 
            		this.to, 
                    PropertyConstant.MODE_ADD);
        }
        else if (this.mode == PropertyConstant.MODE_SHOW) {
            property = new GetWeekdayInfoProperty().getProperty(
            		this.id, 
            		this.weekday, 
            		this.from, 
            		this.to, 
                    PropertyConstant.MODE_SHOW);
        }
        this.propertySheet.setInput(property);
        this.propertySheet.expandAll();

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * 入力値チェックをします。
     * 
     * @return 検証結果
     */
    protected ValidateResult validate() {

        return super.validate();
    }

    /**
     * 入力値を保持したデータモデルを生成します。
     * 
     * @return データモデル
     */
    public Property getInputData() {
        return (Property) this.propertySheet.getInput();
    }

    /**
     * 入力値を保持したデータモデルを設定します。
     * 
     * @param property
     */
    public void setInputData(Property property) {
        propertySheet.setInput(property);
    }

    /**
     * @return Returns the uid.
     */
    public String getUid() {
        return this.id;
    }

    /**
     * ＯＫボタンのテキストを返します。
     * 
     * @return ＯＫボタンのテキスト
     */
    protected String getOkButtonText() {
        if (this.mode == PropertyConstant.MODE_MODIFY) {
            return Messages.getString("modify");
        }
        else if (this.mode == PropertyConstant.MODE_ADD) {
            return Messages.getString("register");
        }
        else{
            return Messages.getString("ok");
        }
    }

    /**
     * キャンセルボタンのテキストを返します。
     * 
     * @return キャンセルボタンのテキスト
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

	@Override
	protected void okPressed() {
        ValidateResult result = this.validate();

        if (result == null || result.isValid()) {
        	//作成時
        	if(this.mode == PropertyConstant.MODE_ADD) {
        		Property addProperty = PropertyUtil.copy(getInputData());
                PropertyUtil.deletePropertyDefine(addProperty);
                if (new AddWeekdayInfoProperty().add(id, addProperty)) {
                    // 成功報告ダイアログを生成
                    MessageBox box = new MessageBox(this.getShell(), SWT.ICON_INFORMATION);
                    box.setText(Messages.getString("successful"));
                    box.setMessage(Messages.getString("message.calendar.8"));
                    box.open();
                } else {
                    // 失敗報告ダイアログを生成
                    MessageBox box = new MessageBox(this.getShell(), SWT.ICON_ERROR);
                    box.setText(Messages.getString("failed"));
                    box.setMessage(Messages.getString("message.calendar.9"));
                    box.open();
                }
        	}
        	else{
        		super.okPressed();
        	}
        } else {
            this.displayError(result);
        }
	}
}