/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.ui.ClusterControlUIPlugin;

/**
 * 状態イメージ定数クラス
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatusImageConstant extends StatusConstant {
    private static Image running = null;

    private static Image end = null;

    private static Image waiting = null;

    private static Image stopping = null;

    private static Image stop = null;

    private static Image wait = null;

    private static Image skip = null;

    private static Image suspend = null;

    private static Image compulsionEnd = null;

    private static Image runError = null;

    /**
     * 種別からImageに変換する
     * 
     * @param type
     * @return
     */
    public static Image typeToImage(int type) {
        ImageRegistry registry = ClusterControlUIPlugin.getDefault()
                .getImageRegistry();

        if (type == TYPE_RUNNING) {
            if (running == null)
                running = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_BLUE).createImage();
            return running;
        } else if (type == TYPE_END) {
            if (end == null)
                end = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_GREEN).createImage();
            return end;
        } else if (type == TYPE_WAIT) {
            if (waiting == null)
                waiting = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_WHITE).createImage();
            return waiting;
        } else if (type == TYPE_STOPPING) {
            if (stopping == null)
                stopping = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_BLUE).createImage();
            return stopping;
        } else if (type == TYPE_STOP) {
            if (stop == null)
                stop = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_RED).createImage();
            return stop;
        } else if (type == TYPE_RESERVING) {
            if (wait == null)
                wait = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_YELLOW).createImage();
            return wait;
        } else if (type == TYPE_SKIP) {
            if (skip == null)
                skip = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_YELLOW).createImage();
            return skip;
        } else if (type == TYPE_SUSPEND) {
            if (suspend == null)
                suspend = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_YELLOW).createImage();
            return suspend;
        } else if (type == TYPE_MODIFIED) {
            if (compulsionEnd == null)
                compulsionEnd = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_GREEN).createImage();
            return compulsionEnd;
        } else if (type == TYPE_ERROR) {
            if (runError == null)
                runError = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_STATUS_RED).createImage();
            return runError;
        }

        return null;
    }
}