/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.ui.ClusterControlUIPlugin;

/**
 * チェックボックスイメージ定数クラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CheckBoxImageConstant {
    private static Image checked = null;

    private static Image unChecked = null;
    
    /**
     * 種別からImageに変換する
     * 
     * @param type
     * @return
     */
    public static Image typeToImage(boolean type) {
        ImageRegistry registry = ClusterControlUIPlugin.getDefault()
                .getImageRegistry();

        if (type) {
            if (checked == null)
            	checked = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_CHECKED)
                        .createImage();
            return checked;
        } else {
            if (unChecked == null)
            	unChecked = registry.getDescriptor(
                        ClusterControlUIPlugin.IMG_UNCHECKED)
                        .createImage();
            return unChecked;
        }
    }
}