/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.ejb.session.NotifyController;
import com.clustercontrol.notify.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 通知を取得するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNotify {

    /**
     * 通知情報を返します。
     * 
     * @param notifyId 通知ID
     * @return 通知情報
     */
    public NotifyInfo getNotify(String notifyId) {

        NotifyController notify = EjbConnectionManager.getConnectionManager()
                .getNotifyController();

        NotifyInfo info = null;
        try {
        	info = notify.getNotify(notifyId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return info;
    }
    
    /**
     * 通知ID一覧を返します。
     * 
     * @return 通知ID一覧
     */
    public ArrayList getNotifyIdList() {

        NotifyController notify = EjbConnectionManager.getConnectionManager()
                .getNotifyController();

        ArrayList records = null;
        try {
            records = notify.getNotifyIdList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
    
    /**
     * 通知一覧を返します。
     * 
     * @return 通知一覧
     */
    public ArrayList getNotifyList() {

        NotifyController notify = EjbConnectionManager.getConnectionManager()
                .getNotifyController();

        ArrayList records = null;
        try {
            records = notify.getNotifyList();
        } catch (RemoteException e) {
        } catch (CreateException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return records;
    }
}