/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.action;

import java.rmi.RemoteException;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.EjbConnectionManager;

/**
 * スコープツリーアイテムを取得するために用いるクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTree {

    /**
     * スコープツリー構造を返します。
     * 
     * @return スコープツリー構造
     */
    public FacilityTreeItem getTreeItem(boolean scopeOnly) {
        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();
        FacilityTreeItem item = null;
        try {
            if (scopeOnly) {
                item = repository.getScopeFacilityTree(Locale.getDefault());
            } else {
                item = repository.getFacilityTree(Locale.getDefault());
            }
        } catch (RemoteException e) {
        } catch (FinderException e) {
        } catch (NamingException e) {
        }
        return item;
    }

    /**
     * セパレータを取得する
     * 
     * @return
     */
    public String getSeparator() {
        RepositoryController repository = EjbConnectionManager
                .getConnectionManager().getRepositoryController();
        String separator = ">";
        try {
            separator = repository.getSeparator();
        } catch (RemoteException e) {
        }
        return separator;
    }
}