/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.accesscontrol.ejb.session.AccessController;
import com.clustercontrol.accesscontrol.util.EjbConnectionManager;
import com.clustercontrol.bean.Property;
import com.clustercontrol.util.Messages;

/**
 * ユーザ変更クラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ModifyUserProperty {

    /**
     * 指定したユーザについて、属性の変更を行います。
     * 
     * @param property 属性情報
     * @return 変更に成功した場合、true
     */
    public boolean edit(Property property) {
		AccessController access = 
			EjbConnectionManager.getConnectionManager().getAccessController();
		
        try {
        	access.modifyUser(property);
            return true;
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
        } catch (FinderException e) {
        }
        return false;
    }
}