/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.bean;

import com.clustercontrol.notify.bean.NotifyInfo;


/**
 * 通知情報クラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyInfoContext
   implements java.io.Serializable
{
	/** 登録（処理種別） */
	public static final int TYPE_ADD = 0;
	/** 更新（処理種別） */
	public static final int TYPE_UPDATE = 1;
	/** 削除（処理種別） */
	public static final int TYPE_DELETE = 2;

    
	/** 処理の種別（通知登録/変更/削除） */
	private int m_type = TYPE_ADD;
	/** 通知ID */ 
	private String m_notifyId = null;
	/** 通知情報 */
	private NotifyInfo m_notifyInfo = null;

	public NotifyInfoContext(){
	}
	
	public NotifyInfoContext(int type, String notifyId, NotifyInfo notifyInfo) {
		super();
		
		this.m_type = type;
		this.m_notifyId = notifyId;
		this.m_notifyInfo = notifyInfo;
	}

	/**
	 * @return notifyInfo を戻します。
	 */
	public NotifyInfo getNotifyInfo() {
		return m_notifyInfo;
	}

	/**
	 * @param notifyInfo 設定する notifyInfo。
	 */
	public void setNotifyInfo(NotifyInfo notifyInfo) {
		this.m_notifyInfo = notifyInfo;
	}

	/**
	 * @return notifyId を戻します。
	 */
	public String getNotifyId() {
		return m_notifyId;
	}

	/**
	 * @param notifyId 設定する notifyId。
	 */
	public void setNotifyId(String notifyId) {
		this.m_notifyId = notifyId;
	}

	/**
	 * @return type を戻します。
	 */
	public int getType() {
		return m_type;
	}

	/**
	 * @param type 設定する type。
	 */
	public void setType(int type) {
		this.m_type = type;
	}
}
