/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.bean;

import com.clustercontrol.bean.ExclusionConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.StatusExpirationConstant;
import com.clustercontrol.bean.StatusValidPeriodConstant;
import com.clustercontrol.bean.ValidConstant;

/**
 * 通知情報クラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyInfo
   implements java.io.Serializable
{
   private java.lang.String m_notifyId;
   private java.lang.String m_description;
   private java.lang.Integer m_eventFlg = new Integer(ValidConstant.TYPE_INVALID);
   private java.lang.Integer m_inhibitionFlg = new Integer(ExclusionConstant.TYPE_NO);
   private java.lang.Integer m_inhibitionFrequency;
   private java.lang.Integer m_inhibitionPeriod;
   private java.sql.Timestamp m_regDate;
   private java.lang.Integer m_statusFlg = new Integer(ValidConstant.TYPE_INVALID);
   private java.lang.Integer m_statusInvalidFlg = new Integer(StatusExpirationConstant.TYPE_UPDATE);
   private java.lang.Integer m_statusUpdatePriority = new Integer(PriorityConstant.TYPE_WARNING);
   private java.lang.Integer m_statusValidPeriod = new Integer(StatusValidPeriodConstant.TYPE_MIN_10);
   private java.sql.Timestamp m_updateDate;
   private java.util.ArrayList<NotifyEventInfo> m_notifyEventInfo;

   public NotifyInfo()
   {
   }

   public NotifyInfo( java.lang.String notifyId,java.lang.String description,java.lang.Integer eventFlg,java.lang.Integer inhibitionFlg,java.lang.Integer inhibitionFrequency,java.lang.Integer inhibitionPeriod,java.sql.Timestamp regDate,java.lang.Integer statusFlg,java.lang.Integer statusInvalidFlg,java.lang.Integer statusUpdatePriority,java.lang.Integer statusValidPeriod,java.sql.Timestamp updateDate,java.util.ArrayList<NotifyEventInfo> notifyEventInfo )
   {
      setNotifyId(notifyId);
      setDescription(description);
      setEventFlg(eventFlg);
      setInhibitionFlg(inhibitionFlg);
      setInhibitionFrequency(inhibitionFrequency);
      setInhibitionPeriod(inhibitionPeriod);
      setRegDate(regDate);
      setStatusFlg(statusFlg);
      setStatusInvalidFlg(statusInvalidFlg);
      setStatusUpdatePriority(statusUpdatePriority);
      setStatusValidPeriod(statusValidPeriod);
      setUpdateDate(updateDate);
      setNotifyEventInfo(notifyEventInfo);
   }

   public NotifyInfo( NotifyInfo otherData )
   {
      setNotifyId(otherData.getNotifyId());
      setDescription(otherData.getDescription());
      setEventFlg(otherData.getEventFlg());
      setInhibitionFlg(otherData.getInhibitionFlg());
      setInhibitionFrequency(otherData.getInhibitionFrequency());
      setInhibitionPeriod(otherData.getInhibitionPeriod());
      setRegDate(otherData.getRegDate());
      setStatusFlg(otherData.getStatusFlg());
      setStatusInvalidFlg(otherData.getStatusInvalidFlg());
      setStatusUpdatePriority(otherData.getStatusUpdatePriority());
      setStatusValidPeriod(otherData.getStatusValidPeriod());
      setUpdateDate(otherData.getUpdateDate());
      setNotifyEventInfo(otherData.getNotifyEventInfo());

   }

   public java.lang.String getPrimaryKey() {
     return  getNotifyId();
   }

   public java.lang.String getNotifyId()
   {
      return this.m_notifyId;
   }
   public void setNotifyId( java.lang.String notifyId )
   {
      this.m_notifyId = notifyId;
   }

   public java.lang.String getDescription()
   {
      return this.m_description;
   }
   public void setDescription( java.lang.String description )
   {
      this.m_description = description;
   }

   public java.lang.Integer getEventFlg()
   {
      return this.m_eventFlg;
   }
   public void setEventFlg( java.lang.Integer eventFlg )
   {
      this.m_eventFlg = eventFlg;
   }

   public java.lang.Integer getInhibitionFlg()
   {
      return this.m_inhibitionFlg;
   }
   public void setInhibitionFlg( java.lang.Integer inhibitionFlg )
   {
      this.m_inhibitionFlg = inhibitionFlg;
   }

   public java.lang.Integer getInhibitionFrequency()
   {
      return this.m_inhibitionFrequency;
   }
   public void setInhibitionFrequency( java.lang.Integer inhibitionFrequency )
   {
      this.m_inhibitionFrequency = inhibitionFrequency;
   }

   public java.lang.Integer getInhibitionPeriod()
   {
      return this.m_inhibitionPeriod;
   }
   public void setInhibitionPeriod( java.lang.Integer inhibitionPeriod )
   {
      this.m_inhibitionPeriod = inhibitionPeriod;
   }

   public java.sql.Timestamp getRegDate()
   {
      return this.m_regDate;
   }
   public void setRegDate( java.sql.Timestamp regDate )
   {
      this.m_regDate = regDate;
   }

   public java.lang.Integer getStatusFlg()
   {
      return this.m_statusFlg;
   }
   public void setStatusFlg( java.lang.Integer statusFlg )
   {
      this.m_statusFlg = statusFlg;
   }

   public java.lang.Integer getStatusInvalidFlg()
   {
      return this.m_statusInvalidFlg;
   }
   public void setStatusInvalidFlg( java.lang.Integer statusInvalidFlg )
   {
      this.m_statusInvalidFlg = statusInvalidFlg;
   }

   public java.lang.Integer getStatusUpdatePriority()
   {
      return this.m_statusUpdatePriority;
   }
   public void setStatusUpdatePriority( java.lang.Integer statusUpdatePriority )
   {
      this.m_statusUpdatePriority = statusUpdatePriority;
   }

   public java.lang.Integer getStatusValidPeriod()
   {
      return this.m_statusValidPeriod;
   }
   public void setStatusValidPeriod( java.lang.Integer statusValidPeriod )
   {
      this.m_statusValidPeriod = statusValidPeriod;
   }

   public java.sql.Timestamp getUpdateDate()
   {
      return this.m_updateDate;
   }
   public void setUpdateDate( java.sql.Timestamp updateDate )
   {
      this.m_updateDate = updateDate;
   }
   
   public java.util.ArrayList<NotifyEventInfo> getNotifyEventInfo(  )
   {
	   return this.m_notifyEventInfo;
	   
   }
   public void setNotifyEventInfo(java.util.ArrayList<NotifyEventInfo> notifyEventInfo)
   {
	   this.m_notifyEventInfo = notifyEventInfo;
   }
}
